/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jee.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.core.util.FindBest;
import org.pac4j.jee.filter.AbstractConfigFilter;
import org.pac4j.jee.util.Pac4JHttpServletRequestWrapper;

public class SecurityFilter
extends AbstractConfigFilter {
    private SecurityLogic<Object, JEEContext> securityLogic;
    private String clients;
    private String authorizers;
    private String matchers;
    private Boolean multiProfile;

    public SecurityFilter() {
    }

    public SecurityFilter(Config config) {
        this.setSharedConfig(config);
    }

    public SecurityFilter(Config config, String clients) {
        this(config);
        this.clients = clients;
    }

    public SecurityFilter(Config config, String clients, String authorizers) {
        this(config, clients);
        this.authorizers = authorizers;
    }

    public SecurityFilter(Config config, String clients, String authorizers, String matchers) {
        this(config, clients, authorizers);
        this.matchers = matchers;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.clients = this.getStringParam(filterConfig, "clients", this.clients);
        this.authorizers = this.getStringParam(filterConfig, "authorizers", this.authorizers);
        this.matchers = this.getStringParam(filterConfig, "matchers", this.matchers);
        this.multiProfile = this.getBooleanParam(filterConfig, "multiProfile", this.multiProfile);
    }

    @Override
    protected final void internalFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Config config = this.getSharedConfig();
        SessionStore bestSessionStore = FindBest.sessionStore(null, (Config)config, (SessionStore)JEESessionStore.INSTANCE);
        HttpActionAdapter bestAdapter = FindBest.httpActionAdapter(null, (Config)config, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        SecurityLogic bestLogic = FindBest.securityLogic(this.securityLogic, (Config)config, (SecurityLogic)DefaultSecurityLogic.INSTANCE);
        JEEContext context = new JEEContext(request, response, bestSessionStore);
        bestLogic.perform((WebContext)context, config, (ctx, profiles, parameters) -> {
            filterChain.doFilter((ServletRequest)(profiles.isEmpty() ? request : new Pac4JHttpServletRequestWrapper(request, profiles)), (ServletResponse)response);
            return null;
        }, bestAdapter, this.clients, this.authorizers, this.matchers, this.multiProfile, new Object[0]);
    }

    public String getClients() {
        return this.clients;
    }

    public void setClients(String clients) {
        this.clients = clients;
    }

    public String getAuthorizers() {
        return this.authorizers;
    }

    public void setAuthorizers(String authorizers) {
        this.authorizers = authorizers;
    }

    public String getMatchers() {
        return this.matchers;
    }

    public void setMatchers(String matchers) {
        this.matchers = matchers;
    }

    public Boolean getMultiProfile() {
        return this.multiProfile;
    }

    public void setMultiProfile(Boolean multiProfile) {
        this.multiProfile = multiProfile;
    }

    public SecurityLogic<Object, JEEContext> getSecurityLogic() {
        return this.securityLogic;
    }

    public void setSecurityLogic(SecurityLogic<Object, JEEContext> securityLogic) {
        this.securityLogic = securityLogic;
    }
}

