/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jee.util;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.JEEContextFactory;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextFactory;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.util.FindBest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@RequestScoped
public class Pac4jProducer {
    private static final Logger logger = LoggerFactory.getLogger(Pac4jProducer.class);

    @Produces
    WebContext getWebContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        logger.trace("Producing a pac4j web context...");
        WebContext webContext = FindBest.webContextFactory(null, (Config)Config.INSTANCE, (WebContextFactory)JEEContextFactory.INSTANCE).newContext(new Object[]{httpServletRequest, httpServletResponse});
        logger.trace("Returning a pac4j web context.");
        return webContext;
    }

    @Produces
    SessionStore getSessionStore() {
        logger.trace("Producing a pac4j session store...");
        SessionStore sessionStore = FindBest.sessionStore(null, (Config)Config.INSTANCE, (SessionStore)JEESessionStore.INSTANCE);
        logger.trace("Returning a pac4j session store.");
        return sessionStore;
    }

    @Produces
    ProfileManager getProfileManager(WebContext webContext, SessionStore sessionStore) {
        logger.trace("Producing a pac4j profile manager...");
        ProfileManager profileManager = new ProfileManager(webContext, sessionStore);
        logger.trace("Returning a pac4j profile manager.");
        return profileManager;
    }
}

