/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client.rest;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.pac4j.cas.credentials.CasCredentials;
import org.pac4j.cas.credentials.authenticator.CasRestAuthenticator;
import org.pac4j.cas.profile.CasProfile;
import org.pac4j.cas.profile.HttpTGTProfile;
import org.pac4j.cas.util.HttpUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.http.client.direct.DirectHttpClient;
import org.pac4j.http.credentials.UsernamePasswordCredentials;
import org.pac4j.http.profile.creator.AuthenticatorProfileCreator;
import org.pac4j.http.profile.creator.ProfileCreator;

public abstract class AbstractCasRestClient
extends DirectHttpClient<UsernamePasswordCredentials> {
    public AbstractCasRestClient() {
    }

    public AbstractCasRestClient(CasRestAuthenticator authenticator) {
        this.setAuthenticator(authenticator);
        this.setProfileCreator((ProfileCreator)new AuthenticatorProfileCreator());
    }

    public HttpTGTProfile requestTicketGrantingTicket(WebContext context) {
        UsernamePasswordCredentials creds = (UsernamePasswordCredentials)this.extractor.extract(context);
        this.getAuthenticator().validate(creds);
        return (HttpTGTProfile)this.getProfileCreator().create((Credentials)creds);
    }

    public void destroyTicketGrantingTicket(WebContext context, HttpTGTProfile profile) {
        HttpURLConnection connection = null;
        try {
            URL endpointURL = new URL(this.getAuthenticator().getCasRestUrl());
            URL deleteURL = new URL(endpointURL, endpointURL.getPath() + "/" + profile.getTicketGrantingTicketId());
            connection = HttpUtils.openDeleteConnection(deleteURL);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new TechnicalException("TGT delete request for `" + (Object)((Object)profile) + "` failed: " + HttpUtils.buildHttpErrorMessage(connection));
            }
        }
        catch (IOException e) {
            try {
                throw new TechnicalException((Throwable)e);
            }
            catch (Throwable throwable) {
                HttpUtils.closeConnection(connection);
                throw throwable;
            }
        }
        HttpUtils.closeConnection(connection);
    }

    public CasCredentials requestServiceTicket(String serviceURL, HttpTGTProfile profile) {
        HttpURLConnection connection;
        block5: {
            connection = null;
            URL endpointURL = new URL(this.getAuthenticator().getCasRestUrl());
            URL ticketURL = new URL(endpointURL, endpointURL.getPath() + "/" + profile.getTicketGrantingTicketId());
            connection = HttpUtils.openPostConnection(ticketURL);
            String payload = HttpUtils.encodeQueryParam("service", serviceURL);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
            out.write(payload);
            out.close();
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) break block5;
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            CasCredentials casCredentials = new CasCredentials(in.readLine(), ((Object)((Object)this)).getClass().getSimpleName());
            HttpUtils.closeConnection(connection);
            return casCredentials;
        }
        try {
            try {
                throw new TechnicalException("Service ticket request for `" + (Object)((Object)profile) + "` failed: " + HttpUtils.buildHttpErrorMessage(connection));
            }
            catch (IOException e) {
                throw new TechnicalException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            HttpUtils.closeConnection(connection);
            throw throwable;
        }
    }

    public CasProfile validateServiceTicket(String serviceURL, CasCredentials ticket) {
        try {
            Assertion assertion = this.getAuthenticator().getTicketValidator().validate(ticket.getServiceTicket(), serviceURL);
            AttributePrincipal principal = assertion.getPrincipal();
            CasProfile casProfile = new CasProfile();
            casProfile.setId(principal.getName());
            casProfile.addAttributes(principal.getAttributes());
            return casProfile;
        }
        catch (TicketValidationException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    public CasRestAuthenticator getAuthenticator() {
        return (CasRestAuthenticator)super.getAuthenticator();
    }

    protected BaseClient<UsernamePasswordCredentials, CommonProfile> newClient() {
        AbstractCasRestClient client = this.newClientType();
        client.setAuthenticator(this.getAuthenticator());
        return client;
    }

    protected abstract AbstractCasRestClient newClientType();
}

