/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.logout;

import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.configuration.ConfigurationKeys;
import org.jasig.cas.client.session.HashMapBackedSessionMappingStorage;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.jasig.cas.client.session.SingleSignOutHandler;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.XmlUtils;
import org.pac4j.cas.logout.LogoutHandler;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasSingleSignOutHandler
implements LogoutHandler {
    protected static final Logger logger = LoggerFactory.getLogger(CasSingleSignOutHandler.class);
    private SessionMappingStorage sessionMappingStorage = new HashMapBackedSessionMappingStorage();
    private String artifactParameterName = Protocol.CAS2.getArtifactParameterName();
    private String logoutParameterName = (String)ConfigurationKeys.LOGOUT_PARAMETER_NAME.getDefaultValue();
    private List<String> safeParameters = Arrays.asList(this.logoutParameterName);
    private boolean eagerlyCreateSessions = true;
    private LogoutStrategy logoutStrategy = CasSingleSignOutHandler.isServlet30() ? new Servlet30LogoutStrategy() : new Servlet25LogoutStrategy();

    public CasSingleSignOutHandler() {
    }

    @Deprecated
    public CasSingleSignOutHandler(SingleSignOutHandler singleSignOutHandler) {
        logger.warn("The provided CAS SingleSignOutHandler is not taken into account anymore!");
    }

    @Override
    public boolean isTokenRequest(WebContext context) {
        J2EContext j2eContext = (J2EContext)context;
        return CommonUtils.isNotBlank((String)CommonUtils.safeGetParameter((HttpServletRequest)j2eContext.getRequest(), (String)this.artifactParameterName, this.safeParameters));
    }

    @Override
    public boolean isLogoutRequest(WebContext context) {
        J2EContext j2eContext = (J2EContext)context;
        HttpServletRequest request = j2eContext.getRequest();
        return "POST".equals(request.getMethod()) && !this.isMultipartRequest(request) && CommonUtils.isNotBlank((String)CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.logoutParameterName, this.safeParameters));
    }

    @Override
    public void recordSession(WebContext context, String ticket) {
        J2EContext j2eContext = (J2EContext)context;
        HttpServletRequest request = j2eContext.getRequest();
        HttpSession session = request.getSession(this.eagerlyCreateSessions);
        if (session == null) {
            logger.debug("No session currently exists (and none created).  Cannot record session information for single sign out.");
            return;
        }
        String token = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.artifactParameterName, this.safeParameters);
        logger.debug("Recording session for token {}", (Object)token);
        try {
            this.sessionMappingStorage.removeBySessionById(session.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sessionMappingStorage.addSessionById(token, session);
    }

    @Override
    public void destroySession(WebContext context) {
        HttpSession session;
        J2EContext j2eContext = (J2EContext)context;
        HttpServletRequest request = j2eContext.getRequest();
        String logoutMessage = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.logoutParameterName, this.safeParameters);
        logger.trace("Logout request:\n{}", (Object)logoutMessage);
        String token = XmlUtils.getTextForElement((String)logoutMessage, (String)"SessionIndex");
        if (CommonUtils.isNotBlank((String)token) && (session = this.sessionMappingStorage.removeSessionByMappingId(token)) != null) {
            String sessionID = session.getId();
            logger.debug("Invalidating session [{}] for token [{}]", (Object)sessionID, (Object)token);
            try {
                session.invalidate();
            }
            catch (IllegalStateException e) {
                logger.debug("Error invalidating session.", (Throwable)e);
            }
            this.logoutStrategy.logout(request);
        }
    }

    private boolean isMultipartRequest(HttpServletRequest request) {
        return request.getContentType() != null && request.getContentType().toLowerCase().startsWith("multipart");
    }

    private static boolean isServlet30() {
        try {
            return HttpServletRequest.class.getMethod("logout", new Class[0]) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public SessionMappingStorage getSessionMappingStorage() {
        return this.sessionMappingStorage;
    }

    public void setSessionMappingStorage(SessionMappingStorage sessionMappingStorage) {
        this.sessionMappingStorage = sessionMappingStorage;
    }

    private class Servlet30LogoutStrategy
    implements LogoutStrategy {
        private Servlet30LogoutStrategy() {
        }

        @Override
        public void logout(HttpServletRequest request) {
            try {
                request.logout();
            }
            catch (ServletException e) {
                logger.debug("Error performing request.logout.");
            }
        }
    }

    private class Servlet25LogoutStrategy
    implements LogoutStrategy {
        private Servlet25LogoutStrategy() {
        }

        @Override
        public void logout(HttpServletRequest request) {
        }
    }

    private static interface LogoutStrategy {
        public void logout(HttpServletRequest var1);
    }
}

