/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

public final class HttpUtils {
    private static final String DEFAULT_QUERY_PARAM_ENCODING = "UTF-8";

    private HttpUtils() {
    }

    public static String buildHttpErrorMessage(HttpURLConnection connection) throws IOException {
        StringBuilder messageBuilder = new StringBuilder("(").append(connection.getResponseCode()).append(")");
        if (connection.getResponseMessage() != null) {
            messageBuilder.append(" ");
            messageBuilder.append(connection.getResponseMessage());
        }
        return messageBuilder.toString();
    }

    public static HttpURLConnection openPostConnection(URL url) throws IOException {
        return HttpUtils.openConnection(url, "POST");
    }

    public static HttpURLConnection openDeleteConnection(URL url) throws IOException {
        return HttpUtils.openConnection(url, "DELETE");
    }

    public static HttpURLConnection openConnection(URL url, String requestMethod) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod(requestMethod);
        return connection;
    }

    public static String encodeQueryParam(String paramName, String paramValue) throws UnsupportedEncodingException {
        return URLEncoder.encode(paramName, DEFAULT_QUERY_PARAM_ENCODING) + "=" + URLEncoder.encode(paramValue, DEFAULT_QUERY_PARAM_ENCODING);
    }

    public static void closeConnection(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }
}

