/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client;

import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.ProxyList;
import org.pac4j.cas.authorization.DefaultCasAuthorizationGenerator;
import org.pac4j.cas.client.CasProxyReceptor;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.cas.credentials.authenticator.CasAuthenticator;
import org.pac4j.cas.credentials.extractor.TicketAndLogoutRequestExtractor;
import org.pac4j.cas.logout.CasLogoutHandler;
import org.pac4j.cas.profile.CasProfile;
import org.pac4j.core.client.IndirectClientV2;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.util.CommonHelper;

public class CasClient
extends IndirectClientV2<TokenCredentials, CasProfile> {
    private CasConfiguration configuration = new CasConfiguration();

    public CasClient() {
    }

    public CasClient(CasConfiguration casConfiguration) {
        this.setConfiguration(casConfiguration);
    }

    @Deprecated
    public CasClient(String casLoginUrl) {
        this.configuration.setLoginUrl(casLoginUrl);
    }

    @Deprecated
    public CasClient(String casLoginUrl, CasProtocol casProtocol) {
        this.configuration.setLoginUrl(casLoginUrl);
        this.configuration.setProtocol(casProtocol);
    }

    @Deprecated
    public CasClient(String casLoginUrl, String casPrefixUrl) {
        this.configuration.setLoginUrl(casLoginUrl);
        this.configuration.setPrefixUrl(casPrefixUrl);
    }

    protected void internalInit(WebContext context) {
        super.internalInit(context);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.configuration.setCallbackUrlResolver(this.getCallbackUrlResolver());
        this.configuration.init(context);
        this.setRedirectActionBuilder(ctx -> {
            String loginUrl = this.configuration.getCallbackUrlResolver().compute(this.configuration.getLoginUrl(), ctx);
            String redirectionUrl = CommonUtils.constructRedirectUrl((String)loginUrl, (String)"service", (String)this.computeFinalCallbackUrl(ctx), (boolean)this.configuration.isRenew(), (boolean)this.configuration.isGateway());
            this.logger.debug("redirectionUrl: {}", (Object)redirectionUrl);
            return RedirectAction.redirect((String)redirectionUrl);
        });
        this.setCredentialsExtractor(new TicketAndLogoutRequestExtractor(this.configuration, this.getName()));
        this.setAuthenticator(new CasAuthenticator(this.configuration, this.callbackUrl));
        this.addAuthorizationGenerator(new DefaultCasAuthorizationGenerator());
    }

    public CasConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CasConfiguration configuration) {
        this.configuration = configuration;
    }

    @Deprecated
    public void setCasLoginUrl(String casLoginUrl) {
        this.configuration.setLoginUrl(casLoginUrl);
    }

    @Deprecated
    public void setCasPrefixUrl(String casPrefixUrl) {
        this.configuration.setPrefixUrl(casPrefixUrl);
    }

    @Deprecated
    public void setCasProtocol(CasProtocol casProtocol) {
        this.configuration.setProtocol(casProtocol);
    }

    @Deprecated
    public void setRenew(boolean renew) {
        this.configuration.setRenew(renew);
    }

    @Deprecated
    public void setGateway(boolean gateway) {
        this.configuration.setGateway(gateway);
    }

    @Deprecated
    public void setLogoutHandler(CasLogoutHandler logoutHandler) {
        this.configuration.setLogoutHandler(logoutHandler);
    }

    @Deprecated
    public void setAcceptAnyProxy(boolean acceptAnyProxy) {
        this.configuration.setAcceptAnyProxy(acceptAnyProxy);
    }

    @Deprecated
    public void setAllowedProxyChains(ProxyList allowedProxyChains) {
        this.configuration.setAllowedProxyChains(allowedProxyChains);
    }

    @Deprecated
    public void setCasProxyReceptor(CasProxyReceptor casProxyReceptor) {
        this.configuration.setProxyReceptor(casProxyReceptor);
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"callbackUrl", this.callbackUrl, "configuration", this.configuration});
    }
}

