/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client;

import java.util.Timer;
import java.util.TimerTask;
import org.jasig.cas.client.proxy.CleanUpTimerTask;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorageImpl;
import org.jasig.cas.client.util.CommonUtils;
import org.pac4j.cas.profile.CasProfile;
import org.pac4j.core.client.IndirectClientV2;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CasProxyReceptor
extends IndirectClientV2<TokenCredentials, CasProfile> {
    private static final Logger logger = LoggerFactory.getLogger(CasProxyReceptor.class);
    private ProxyGrantingTicketStorage proxyGrantingTicketStorage = new ProxyGrantingTicketStorageImpl();
    public static final String PARAM_PROXY_GRANTING_TICKET_IOU = "pgtIou";
    public static final String PARAM_PROXY_GRANTING_TICKET = "pgtId";
    private int millisBetweenCleanUps = 60000;
    private Timer timer;
    private TimerTask timerTask;

    protected void internalInit(WebContext context) {
        super.internalInit(context);
        CommonHelper.assertNotNull((String)"proxyGrantingTicketStorage", (Object)this.proxyGrantingTicketStorage);
        if (this.millisBetweenCleanUps > 0) {
            if (this.timer == null) {
                this.timer = new Timer(true);
            }
            if (this.timerTask == null) {
                this.timerTask = new CleanUpTimerTask(this.proxyGrantingTicketStorage);
            }
            this.timer.schedule(this.timerTask, this.millisBetweenCleanUps, (long)this.millisBetweenCleanUps);
        }
        this.setRedirectActionBuilder(ctx -> {
            throw new TechnicalException("Not supported by the CAS proxy receptor");
        });
        this.setCredentialsExtractor(ctx -> {
            String proxyGrantingTicketIou = ctx.getRequestParameter(PARAM_PROXY_GRANTING_TICKET_IOU);
            logger.debug("proxyGrantingTicketIou: {}", (Object)proxyGrantingTicketIou);
            String proxyGrantingTicket = ctx.getRequestParameter(PARAM_PROXY_GRANTING_TICKET);
            logger.debug("proxyGrantingTicket: {}", (Object)proxyGrantingTicket);
            if (CommonUtils.isBlank((String)proxyGrantingTicket) || CommonUtils.isBlank((String)proxyGrantingTicketIou)) {
                ctx.writeResponseContent("");
                String message = "Missing proxyGrantingTicket or proxyGrantingTicketIou";
                throw HttpAction.ok((String)"Missing proxyGrantingTicket or proxyGrantingTicketIou", (WebContext)ctx);
            }
            this.proxyGrantingTicketStorage.save(proxyGrantingTicketIou, proxyGrantingTicket);
            ctx.writeResponseContent("<?xml version=\"1.0\"?>");
            ctx.writeResponseContent("<casClient:proxySuccess xmlns:casClient=\"http://www.yale.edu/tp/casClient\" />");
            String message = "No credential for CAS proxy receptor -> returns ok";
            logger.debug("No credential for CAS proxy receptor -> returns ok");
            throw HttpAction.ok((String)"No credential for CAS proxy receptor -> returns ok", (WebContext)ctx);
        });
        this.setAuthenticator((credentials, ctx) -> {
            throw new TechnicalException("Not supported by the CAS proxy receptor");
        });
    }

    public ProxyGrantingTicketStorage getProxyGrantingTicketStorage() {
        return this.proxyGrantingTicketStorage;
    }

    public void setProxyGrantingTicketStorage(ProxyGrantingTicketStorage proxyGrantingTicketStorage) {
        this.proxyGrantingTicketStorage = proxyGrantingTicketStorage;
    }

    public int getMillisBetweenCleanUps() {
        return this.millisBetweenCleanUps;
    }

    public void setMillisBetweenCleanUps(int millisBetweenCleanUps) {
        this.millisBetweenCleanUps = millisBetweenCleanUps;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"callbackUrl", this.callbackUrl, "proxyGrantingTicketStorage", this.proxyGrantingTicketStorage, "millisBetweenCleanUps", this.millisBetweenCleanUps});
    }
}

