/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client.direct;

import org.jasig.cas.client.util.CommonUtils;
import org.pac4j.cas.authorization.DefaultCasAuthorizationGenerator;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.credentials.authenticator.CasAuthenticator;
import org.pac4j.cas.profile.CasProfile;
import org.pac4j.core.client.DirectClientV2;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.credentials.extractor.ParameterExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.CallbackUrlResolver;
import org.pac4j.core.util.CommonHelper;

public class DirectCasClient
extends DirectClientV2<TokenCredentials, CasProfile> {
    private CasConfiguration configuration;

    public DirectCasClient() {
    }

    public DirectCasClient(CasConfiguration casConfiguration) {
        this.configuration = casConfiguration;
    }

    protected TokenCredentials retrieveCredentials(WebContext context) throws HttpAction {
        this.init(context);
        try {
            TokenCredentials credentials;
            String currentUrl = context.getFullRequestURL();
            String loginUrl = this.configuration.getLoginUrl();
            CallbackUrlResolver callbackUrlResolver = this.configuration.getCallbackUrlResolver();
            if (callbackUrlResolver != null) {
                currentUrl = callbackUrlResolver.compute(currentUrl, context);
                loginUrl = callbackUrlResolver.compute(loginUrl, context);
            }
            if ((credentials = (TokenCredentials)this.getCredentialsExtractor().extract(context)) == null) {
                String redirectionUrl = CommonUtils.constructRedirectUrl((String)loginUrl, (String)"service", (String)currentUrl, (boolean)this.configuration.isRenew(), (boolean)false);
                this.logger.debug("redirectionUrl: {}", (Object)redirectionUrl);
                throw HttpAction.redirect((String)"no ticket -> force redirect to login page", (WebContext)context, (String)redirectionUrl);
            }
            currentUrl = CommonHelper.substringBefore((String)currentUrl, (String)"?ticket=");
            currentUrl = CommonHelper.substringBefore((String)currentUrl, (String)"&ticket=");
            CasAuthenticator casAuthenticator = new CasAuthenticator(this.configuration, currentUrl);
            casAuthenticator.init(context);
            casAuthenticator.validate(credentials, context);
            return credentials;
        }
        catch (CredentialsException e) {
            this.logger.error("Failed to retrieve or validate CAS credentials", (Throwable)e);
            return null;
        }
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        CommonHelper.assertTrue((!this.configuration.isGateway() ? 1 : 0) != 0, (String)"the DirectCasClient can not support gateway to avoid infinite loops");
        this.configuration.init(context);
        this.setCredentialsExtractor((CredentialsExtractor)new ParameterExtractor("ticket", true, false, this.getName()));
        super.setAuthenticator((Authenticator)new CasAuthenticator(this.configuration, "fake"));
        this.addAuthorizationGenerator(new DefaultCasAuthorizationGenerator());
    }

    public CasConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CasConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setAuthenticator(Authenticator authenticator) {
        throw new TechnicalException("You can not set an Authenticator for the DirectCasClient at startup. A new CasAuthenticator is automatically created for each request");
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"configuration", this.configuration});
    }
}

