/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client.rest;

import org.pac4j.cas.client.rest.AbstractCasRestClient;
import org.pac4j.cas.credentials.authenticator.CasRestAuthenticator;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.util.CommonHelper;

public class CasRestBasicAuthClient
extends AbstractCasRestClient {
    private String casServerPrefixUrl;
    private String headerName = "Authorization";
    private String prefixHeader = "Basic ";

    public CasRestBasicAuthClient() {
    }

    public CasRestBasicAuthClient(String casServerPrefixUrl) {
        this.casServerPrefixUrl = casServerPrefixUrl;
    }

    public CasRestBasicAuthClient(Authenticator authenticator) {
        this.setAuthenticator(authenticator);
    }

    public CasRestBasicAuthClient(String casServerPrefixUrl, String headerName, String prefixHeader) {
        this.casServerPrefixUrl = casServerPrefixUrl;
        this.headerName = headerName;
        this.prefixHeader = prefixHeader;
    }

    public CasRestBasicAuthClient(Authenticator authenticator, String headerName, String prefixHeader) {
        this.setAuthenticator(authenticator);
        this.headerName = headerName;
        this.prefixHeader = prefixHeader;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotBlank((String)"headerName", (String)this.headerName);
        CommonHelper.assertNotNull((String)"prefixHeader", (Object)this.prefixHeader);
        this.setCredentialsExtractor((CredentialsExtractor)new BasicAuthExtractor(this.headerName, this.prefixHeader, this.getName()));
        if (CommonHelper.isNotBlank((String)this.casServerPrefixUrl)) {
            this.setAuthenticator(new CasRestAuthenticator(this.casServerPrefixUrl));
        }
    }

    public String getCasServerPrefixUrl() {
        return this.casServerPrefixUrl;
    }

    public void setCasServerPrefixUrl(String casServerPrefixUrl) {
        this.casServerPrefixUrl = casServerPrefixUrl;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getPrefixHeader() {
        return this.prefixHeader;
    }

    public void setPrefixHeader(String prefixHeader) {
        this.prefixHeader = prefixHeader;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "headerName", this.headerName, "prefixHeader", this.prefixHeader, "extractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }
}

