/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client.rest;

import org.pac4j.cas.client.rest.AbstractCasRestClient;
import org.pac4j.cas.credentials.authenticator.CasRestAuthenticator;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.credentials.extractor.FormExtractor;
import org.pac4j.core.util.CommonHelper;

public class CasRestFormClient
extends AbstractCasRestClient {
    private String casServerPrefixUrl;
    private String usernameParameter = "username";
    private String passwordParameter = "password";

    public CasRestFormClient() {
    }

    public CasRestFormClient(String casServerPrefixUrl) {
        this.casServerPrefixUrl = casServerPrefixUrl;
    }

    public CasRestFormClient(Authenticator authenticator) {
        this.setAuthenticator(authenticator);
    }

    public CasRestFormClient(String casServerPrefixUrl, String usernameParameter, String passwordParameter) {
        this.casServerPrefixUrl = casServerPrefixUrl;
        this.usernameParameter = usernameParameter;
        this.passwordParameter = passwordParameter;
    }

    public CasRestFormClient(Authenticator authenticator, String usernameParameter, String passwordParameter) {
        this.setAuthenticator(authenticator);
        this.usernameParameter = usernameParameter;
        this.passwordParameter = passwordParameter;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotBlank((String)"usernameParameter", (String)this.usernameParameter);
        CommonHelper.assertNotBlank((String)"passwordParameter", (String)this.passwordParameter);
        this.setCredentialsExtractor((CredentialsExtractor)new FormExtractor(this.usernameParameter, this.passwordParameter, this.getName()));
        if (CommonHelper.isNotBlank((String)this.casServerPrefixUrl)) {
            this.setAuthenticator(new CasRestAuthenticator(this.casServerPrefixUrl));
        }
    }

    public String getCasServerPrefixUrl() {
        return this.casServerPrefixUrl;
    }

    public void setCasServerPrefixUrl(String casServerPrefixUrl) {
        this.casServerPrefixUrl = casServerPrefixUrl;
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    @Deprecated
    public String getUsername() {
        return this.usernameParameter;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    @Deprecated
    public String getPassword() {
        return this.passwordParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "usernameParameter", this.usernameParameter, "passwordParameter", this.passwordParameter, "extractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }
}

