/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.config;

import org.jasig.cas.client.validation.Cas10TicketValidator;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.Cas30ProxyTicketValidator;
import org.jasig.cas.client.validation.Cas30ServiceTicketValidator;
import org.jasig.cas.client.validation.ProxyList;
import org.jasig.cas.client.validation.Saml11TicketValidator;
import org.jasig.cas.client.validation.TicketValidator;
import org.pac4j.cas.client.CasProxyReceptor;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.cas.logout.CasLogoutHandler;
import org.pac4j.cas.logout.CasSingleSignOutHandler;
import org.pac4j.cas.logout.NoLogoutHandler;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.CallbackUrlResolver;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;

public class CasConfiguration
extends InitializableWebObject {
    public static final String TICKET_PARAMETER = "ticket";
    public static final String SERVICE_PARAMETER = "service";
    public static final String LOGOUT_REQUEST_PARAMETER = "logoutRequest";
    public static final String SESSION_INDEX_TAG = "SessionIndex";
    public static final String RELAY_STATE_PARAMETER = "RelayState";
    private String encoding = "UTF-8";
    private String loginUrl;
    private String prefixUrl;
    private long timeTolerance = 1000L;
    private CasProtocol protocol = CasProtocol.CAS30;
    private boolean renew = false;
    private boolean gateway = false;
    private boolean acceptAnyProxy = false;
    private ProxyList allowedProxyChains = new ProxyList();
    private CasLogoutHandler logoutHandler;
    private TicketValidator ticketValidator;
    private CasProxyReceptor proxyReceptor;
    private CallbackUrlResolver callbackUrlResolver;

    public CasConfiguration() {
    }

    public CasConfiguration(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public CasConfiguration(String loginUrl, CasProtocol protocol) {
        this.loginUrl = loginUrl;
        this.protocol = protocol;
    }

    public CasConfiguration(String loginUrl, String prefixUrl) {
        this.loginUrl = loginUrl;
        this.prefixUrl = prefixUrl;
    }

    protected void internalInit(WebContext context) {
        if (CommonHelper.isBlank((String)this.loginUrl) && CommonHelper.isBlank((String)this.prefixUrl)) {
            throw new TechnicalException("loginUrl and prefixUrl cannot be both blank");
        }
        this.initializeClientConfiguration(context);
        this.initializeLogoutHandler(context);
        if (this.protocol == CasProtocol.CAS10) {
            this.initializeCas10Protocol();
        } else if (this.protocol == CasProtocol.CAS20) {
            this.initializeCas20Protocol(context);
        } else if (this.protocol == CasProtocol.CAS20_PROXY) {
            this.initializeCas20ProxyProtocol(context);
        } else if (this.protocol == CasProtocol.CAS30) {
            this.initializeCas30Protocol(context);
        } else if (this.protocol == CasProtocol.CAS30_PROXY) {
            this.initializeCas30ProxyProtocol(context);
        } else if (this.protocol == CasProtocol.SAML) {
            this.initializeSAMLProtocol();
        }
    }

    protected void initializeClientConfiguration(WebContext context) {
        if (this.prefixUrl != null && !this.prefixUrl.endsWith("/")) {
            this.prefixUrl = this.prefixUrl + "/";
        }
        if (CommonHelper.isBlank((String)this.prefixUrl)) {
            this.prefixUrl = this.loginUrl.replaceFirst("/login$", "/");
        } else if (CommonHelper.isBlank((String)this.loginUrl)) {
            this.loginUrl = this.prefixUrl + "login";
        }
        if (this.callbackUrlResolver != null) {
            this.prefixUrl = this.callbackUrlResolver.compute(this.prefixUrl, context);
            this.loginUrl = this.callbackUrlResolver.compute(this.loginUrl, context);
        }
    }

    private void initializeLogoutHandler(WebContext context) {
        if (this.logoutHandler == null) {
            this.logoutHandler = context instanceof J2EContext ? new CasSingleSignOutHandler() : new NoLogoutHandler();
        }
    }

    protected void initializeSAMLProtocol() {
        Saml11TicketValidator saml11TicketValidator = new Saml11TicketValidator(this.prefixUrl);
        saml11TicketValidator.setTolerance(this.getTimeTolerance());
        saml11TicketValidator.setEncoding(this.encoding);
        this.setTicketValidator((TicketValidator)saml11TicketValidator);
    }

    protected void initializeCas30ProxyProtocol(WebContext context) {
        Cas30ProxyTicketValidator cas30ProxyTicketValidator = new Cas30ProxyTicketValidator(this.prefixUrl);
        cas30ProxyTicketValidator.setEncoding(this.encoding);
        cas30ProxyTicketValidator.setAcceptAnyProxy(this.acceptAnyProxy);
        cas30ProxyTicketValidator.setAllowedProxyChains(this.allowedProxyChains);
        if (this.proxyReceptor != null) {
            cas30ProxyTicketValidator.setProxyCallbackUrl(this.proxyReceptor.computeFinalCallbackUrl(context));
            cas30ProxyTicketValidator.setProxyGrantingTicketStorage(this.proxyReceptor.getProxyGrantingTicketStorage());
        }
        this.setTicketValidator((TicketValidator)cas30ProxyTicketValidator);
    }

    protected void initializeCas30Protocol(WebContext context) {
        Cas30ServiceTicketValidator cas30ServiceTicketValidator = new Cas30ServiceTicketValidator(this.prefixUrl);
        cas30ServiceTicketValidator.setEncoding(this.encoding);
        if (this.proxyReceptor != null) {
            cas30ServiceTicketValidator.setProxyCallbackUrl(this.proxyReceptor.computeFinalCallbackUrl(context));
            cas30ServiceTicketValidator.setProxyGrantingTicketStorage(this.proxyReceptor.getProxyGrantingTicketStorage());
        }
        this.setTicketValidator((TicketValidator)cas30ServiceTicketValidator);
    }

    protected void initializeCas20ProxyProtocol(WebContext context) {
        Cas20ProxyTicketValidator cas20ProxyTicketValidator = new Cas20ProxyTicketValidator(this.prefixUrl);
        cas20ProxyTicketValidator.setEncoding(this.encoding);
        cas20ProxyTicketValidator.setAcceptAnyProxy(this.acceptAnyProxy);
        cas20ProxyTicketValidator.setAllowedProxyChains(this.allowedProxyChains);
        if (this.proxyReceptor != null) {
            cas20ProxyTicketValidator.setProxyCallbackUrl(this.proxyReceptor.computeFinalCallbackUrl(context));
            cas20ProxyTicketValidator.setProxyGrantingTicketStorage(this.proxyReceptor.getProxyGrantingTicketStorage());
        }
        this.setTicketValidator((TicketValidator)cas20ProxyTicketValidator);
    }

    protected void initializeCas20Protocol(WebContext context) {
        Cas20ServiceTicketValidator cas20ServiceTicketValidator = new Cas20ServiceTicketValidator(this.prefixUrl);
        cas20ServiceTicketValidator.setEncoding(this.encoding);
        if (this.proxyReceptor != null) {
            cas20ServiceTicketValidator.setProxyCallbackUrl(this.proxyReceptor.computeFinalCallbackUrl(context));
            cas20ServiceTicketValidator.setProxyGrantingTicketStorage(this.proxyReceptor.getProxyGrantingTicketStorage());
        }
        this.setTicketValidator((TicketValidator)cas20ServiceTicketValidator);
    }

    protected void initializeCas10Protocol() {
        Cas10TicketValidator cas10TicketValidator = new Cas10TicketValidator(this.prefixUrl);
        cas10TicketValidator.setEncoding(this.encoding);
        this.setTicketValidator((TicketValidator)cas10TicketValidator);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getPrefixUrl() {
        return this.prefixUrl;
    }

    public void setPrefixUrl(String prefixUrl) {
        this.prefixUrl = prefixUrl;
    }

    public long getTimeTolerance() {
        return this.timeTolerance;
    }

    public void setTimeTolerance(long timeTolerance) {
        this.timeTolerance = timeTolerance;
    }

    public CasProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(CasProtocol protocol) {
        this.protocol = protocol;
    }

    public boolean isRenew() {
        return this.renew;
    }

    public void setRenew(boolean renew) {
        this.renew = renew;
    }

    public boolean isGateway() {
        return this.gateway;
    }

    public void setGateway(boolean gateway) {
        this.gateway = gateway;
    }

    public boolean isAcceptAnyProxy() {
        return this.acceptAnyProxy;
    }

    public void setAcceptAnyProxy(boolean acceptAnyProxy) {
        this.acceptAnyProxy = acceptAnyProxy;
    }

    public ProxyList getAllowedProxyChains() {
        return this.allowedProxyChains;
    }

    public void setAllowedProxyChains(ProxyList allowedProxyChains) {
        this.allowedProxyChains = allowedProxyChains;
    }

    public CasLogoutHandler getLogoutHandler() {
        return this.logoutHandler;
    }

    public void setLogoutHandler(CasLogoutHandler logoutHandler) {
        this.logoutHandler = logoutHandler;
    }

    public TicketValidator getTicketValidator() {
        return this.ticketValidator;
    }

    public void setTicketValidator(TicketValidator ticketValidator) {
        if (this.ticketValidator == null) {
            this.ticketValidator = ticketValidator;
        }
    }

    public CasProxyReceptor getProxyReceptor() {
        return this.proxyReceptor;
    }

    public void setProxyReceptor(CasProxyReceptor proxyReceptor) {
        this.proxyReceptor = proxyReceptor;
    }

    public CallbackUrlResolver getCallbackUrlResolver() {
        return this.callbackUrlResolver;
    }

    public void setCallbackUrlResolver(CallbackUrlResolver callbackUrlResolver) {
        if (this.callbackUrlResolver == null) {
            this.callbackUrlResolver = callbackUrlResolver;
        }
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"loginUrl", this.loginUrl, "prefixUrl", this.prefixUrl, "protocol", this.protocol, "renew", this.renew, "gateway", this.gateway, "encoding", this.encoding, "logoutHandler", this.logoutHandler, "acceptAnyProxy", this.acceptAnyProxy, "allowedProxyChains", this.allowedProxyChains, "proxyReceptor", this.proxyReceptor, "timeTolerance", this.timeTolerance});
    }
}

