/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.credentials.authenticator;

import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.profile.CasProfile;
import org.pac4j.cas.profile.CasProxyProfile;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.CallbackUrlResolver;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasAuthenticator
extends InitializableWebObject
implements Authenticator<TokenCredentials> {
    private static final Logger logger = LoggerFactory.getLogger(CasAuthenticator.class);
    private CasConfiguration configuration;
    private String callbackUrl;

    public CasAuthenticator() {
    }

    public CasAuthenticator(CasConfiguration configuration, String callbackUrl) {
        this.configuration = configuration;
        this.callbackUrl = callbackUrl;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        CommonHelper.assertNotBlank((String)"callbackUrl", (String)this.callbackUrl);
        this.configuration.init(context);
    }

    public void validate(TokenCredentials credentials, WebContext context) throws HttpAction {
        this.init(context);
        String ticket = credentials.getToken();
        try {
            CasProfile casProfile;
            String finalCallbackUrl = this.callbackUrl;
            CallbackUrlResolver callbackUrlResolver = this.configuration.getCallbackUrlResolver();
            if (callbackUrlResolver != null) {
                finalCallbackUrl = callbackUrlResolver.compute(finalCallbackUrl, context);
            }
            Assertion assertion = this.configuration.getTicketValidator().validate(ticket, finalCallbackUrl);
            AttributePrincipal principal = assertion.getPrincipal();
            logger.debug("principal: {}", (Object)principal);
            if (this.configuration.getProxyReceptor() != null) {
                casProfile = new CasProxyProfile();
                ((CasProxyProfile)casProfile).setPrincipal(principal);
            } else {
                casProfile = new CasProfile();
            }
            casProfile.setId(principal.getName());
            casProfile.addAttributes(principal.getAttributes());
            logger.debug("casProfile: {}", (Object)casProfile);
            credentials.setUserProfile((CommonProfile)casProfile);
        }
        catch (TicketValidationException e) {
            String message = "cannot validate CAS ticket: " + ticket;
            throw new TechnicalException(message, (Throwable)e);
        }
    }

    public CasConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CasConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"configuration", this.configuration, "callbackUrl", this.callbackUrl});
    }
}

