/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.credentials.authenticator;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.jasig.cas.client.validation.Cas30ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidator;
import org.pac4j.cas.profile.CasRestProfile;
import org.pac4j.cas.util.HttpUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;

public class CasRestAuthenticator
extends InitializableWebObject
implements Authenticator<UsernamePasswordCredentials> {
    private String casServerPrefixUrl;
    private String casRestUrl;
    private TicketValidator ticketValidator;

    public CasRestAuthenticator() {
    }

    public CasRestAuthenticator(String casServerPrefixUrl) {
        this.casServerPrefixUrl = casServerPrefixUrl;
    }

    public CasRestAuthenticator(String casServerPrefixUrl, String casRestUrl) {
        this.casServerPrefixUrl = casServerPrefixUrl;
        this.casRestUrl = casRestUrl;
    }

    public CasRestAuthenticator(String casServerPrefixUrl, String casRestUrl, TicketValidator ticketValidator) {
        this.casServerPrefixUrl = casServerPrefixUrl;
        this.casRestUrl = casRestUrl;
        this.ticketValidator = ticketValidator;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotBlank((String)"casServerPrefixUrl", (String)this.casServerPrefixUrl);
        if (CommonHelper.isBlank((String)this.casRestUrl)) {
            this.casRestUrl = this.casServerPrefixUrl;
            if (!this.casRestUrl.endsWith("/")) {
                this.casRestUrl = this.casRestUrl + "/";
            }
            this.casRestUrl = this.casRestUrl + "v1/tickets";
        }
        if (this.ticketValidator == null) {
            this.ticketValidator = new Cas30ServiceTicketValidator(this.casServerPrefixUrl);
        }
    }

    public void validate(UsernamePasswordCredentials credentials, WebContext context) throws HttpAction {
        this.init(context);
        if (credentials == null || credentials.getPassword() == null || credentials.getUsername() == null) {
            throw new TechnicalException("Credentials are required");
        }
        String ticketGrantingTicketId = this.requestTicketGrantingTicket(credentials.getUsername(), credentials.getPassword());
        CasRestProfile profile = new CasRestProfile(ticketGrantingTicketId, credentials.getUsername());
        credentials.setUserProfile((CommonProfile)profile);
    }

    private String requestTicketGrantingTicket(String username, String password) {
        int responseCode;
        String locationHeader;
        HttpURLConnection connection;
        block5: {
            connection = null;
            connection = HttpUtils.openPostConnection(new URL(this.casRestUrl));
            String payload = HttpUtils.encodeQueryParam("username", username) + "&" + HttpUtils.encodeQueryParam("password", password);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), "UTF-8"));
            out.write(payload);
            out.close();
            locationHeader = connection.getHeaderField("location");
            responseCode = connection.getResponseCode();
            if (locationHeader == null || responseCode != 201) break block5;
            String string = locationHeader.substring(locationHeader.lastIndexOf("/") + 1);
            HttpUtils.closeConnection(connection);
            return string;
        }
        try {
            try {
                throw new TechnicalException("Ticket granting ticket request failed: " + locationHeader + " " + responseCode + HttpUtils.buildHttpErrorMessage(connection));
            }
            catch (IOException e) {
                throw new TechnicalException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            HttpUtils.closeConnection(connection);
            throw throwable;
        }
    }

    public String getCasServerPrefixUrl() {
        return this.casServerPrefixUrl;
    }

    public void setCasServerPrefixUrl(String casServerPrefixUrl) {
        this.casServerPrefixUrl = casServerPrefixUrl;
    }

    public String getCasRestUrl() {
        return this.casRestUrl;
    }

    public void setCasRestUrl(String casRestUrl) {
        this.casRestUrl = casRestUrl;
    }

    public TicketValidator getTicketValidator() {
        return this.ticketValidator;
    }

    public void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"casServerPrefixUrl", this.casServerPrefixUrl, "casRestUrl", this.casRestUrl, "ticketValidator", this.ticketValidator});
    }
}

