/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.logout;

import javax.servlet.http.HttpSession;
import org.jasig.cas.client.session.HashMapBackedSessionMappingStorage;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.pac4j.cas.logout.CasLogoutHandler;
import org.pac4j.core.context.J2EContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasSingleSignOutHandler
implements CasLogoutHandler<J2EContext> {
    protected static final Logger logger = LoggerFactory.getLogger(CasSingleSignOutHandler.class);
    private SessionMappingStorage sessionMappingStorage = new HashMapBackedSessionMappingStorage();
    private boolean eagerlyCreateSessions = true;

    @Override
    public void recordSession(J2EContext context, String ticket) {
        HttpSession session = context.getRequest().getSession(this.eagerlyCreateSessions);
        if (session == null) {
            logger.debug("No session currently exists (and none created). Cannot record session information for single sign out.");
            return;
        }
        String sessionId = session.getId();
        try {
            this.sessionMappingStorage.removeBySessionById(sessionId);
        }
        catch (Exception e) {
            logger.warn("failed to remove session by id: ", (Object)sessionId);
        }
        this.sessionMappingStorage.addSessionById(ticket, session);
    }

    @Override
    public void destroySessionBack(J2EContext context, String ticket) {
        HttpSession session = this.sessionMappingStorage.removeSessionByMappingId(ticket);
        if (session != null) {
            String sessionID = session.getId();
            logger.debug("Invalidating session [{}] for ticket [{}]", (Object)sessionID, (Object)ticket);
            try {
                session.invalidate();
            }
            catch (IllegalStateException e) {
                logger.debug("Error invalidating session", (Throwable)e);
            }
        }
    }

    public boolean isEagerlyCreateSessions() {
        return this.eagerlyCreateSessions;
    }

    public void setEagerlyCreateSessions(boolean eagerlyCreateSessions) {
        this.eagerlyCreateSessions = eagerlyCreateSessions;
    }

    public SessionMappingStorage getSessionMappingStorage() {
        return this.sessionMappingStorage;
    }

    public void setSessionMappingStorage(SessionMappingStorage sessionMappingStorage) {
        this.sessionMappingStorage = sessionMappingStorage;
    }
}

