/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.credentials.extractor;

import java.util.Base64;
import java.util.Optional;
import java.util.zip.Inflater;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.util.CommonUtils;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.core.context.ContextHelper;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.NoContentAction;
import org.pac4j.core.exception.http.RedirectionActionHelper;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketAndLogoutRequestExtractor
implements CredentialsExtractor<TokenCredentials> {
    private static final int DECOMPRESSION_FACTOR = 10;
    private static final Logger logger = LoggerFactory.getLogger(TicketAndLogoutRequestExtractor.class);
    protected CasConfiguration configuration;

    public TicketAndLogoutRequestExtractor(CasConfiguration configuration) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        this.configuration = configuration;
    }

    public Optional<TokenCredentials> extract(WebContext context) {
        LogoutHandler logoutHandler = this.configuration.findLogoutHandler();
        if (this.isTokenRequest(context)) {
            String ticket = this.getArtifactParameter(context).get();
            logoutHandler.recordSession(context, ticket);
            TokenCredentials casCredentials = new TokenCredentials(ticket);
            logger.debug("casCredentials: {}", (Object)casCredentials);
            return Optional.of(casCredentials);
        }
        if (this.isBackLogoutRequest(context)) {
            String logoutMessage = (String)context.getRequestParameter("logoutRequest").get();
            logger.trace("Logout request:\n{}", (Object)logoutMessage);
            String ticket = CommonHelper.substringBetween((String)logoutMessage, (String)"SessionIndex>", (String)"</");
            if (CommonUtils.isNotBlank((String)ticket)) {
                logoutHandler.destroySessionBack(context, ticket);
            }
            logger.debug("back logout request: no credential returned");
            throw NoContentAction.INSTANCE;
        }
        if (this.isFrontLogoutRequest(context)) {
            String logoutMessage = this.uncompressLogoutMessage((String)context.getRequestParameter("logoutRequest").get());
            logger.trace("Logout request:\n{}", (Object)logoutMessage);
            String ticket = CommonHelper.substringBetween((String)logoutMessage, (String)"SessionIndex>", (String)"</");
            if (CommonUtils.isNotBlank((String)ticket)) {
                logoutHandler.destroySessionFront(context, ticket);
            }
            logger.debug("front logout request: no credential returned");
            this.computeRedirectionToServerIfNecessary(context);
        }
        return Optional.empty();
    }

    protected boolean isTokenRequest(WebContext context) {
        return this.getArtifactParameter(context).isPresent();
    }

    protected Optional<String> getArtifactParameter(WebContext context) {
        Optional optValue;
        if (this.configuration.getProtocol() == CasProtocol.SAML && (optValue = context.getRequestParameter(Protocol.SAML11.getArtifactParameterName())).isPresent()) {
            return optValue;
        }
        return context.getRequestParameter("ticket");
    }

    protected boolean isBackLogoutRequest(WebContext context) {
        return ContextHelper.isPost((WebContext)context) && !this.isMultipartRequest(context) && context.getRequestParameter("logoutRequest").isPresent();
    }

    private boolean isMultipartRequest(WebContext context) {
        Optional contentType = context.getRequestHeader("Content-Type");
        return contentType.isPresent() && ((String)contentType.get()).toLowerCase().startsWith("multipart");
    }

    private boolean isFrontLogoutRequest(WebContext context) {
        return ContextHelper.isGet((WebContext)context) && context.getRequestParameter("logoutRequest").isPresent();
    }

    private String uncompressLogoutMessage(String originalMessage) {
        byte[] binaryMessage = Base64.getMimeDecoder().decode(originalMessage);
        Inflater decompresser = null;
        try {
            decompresser = new Inflater();
            decompresser.setInput(binaryMessage);
            byte[] result = new byte[binaryMessage.length * 10];
            int resultLength = decompresser.inflate(result);
            String string = new String(result, 0, resultLength, "UTF-8");
            return string;
        }
        catch (Exception e) {
            logger.error("Unable to decompress logout message", (Throwable)e);
            throw new TechnicalException((Throwable)e);
        }
        finally {
            if (decompresser != null) {
                decompresser.end();
            }
        }
    }

    private void computeRedirectionToServerIfNecessary(WebContext context) {
        Optional relayStateValue = context.getRequestParameter("RelayState");
        if (relayStateValue.isPresent()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.configuration.getPrefixUrl());
            if (!this.configuration.getPrefixUrl().endsWith("/")) {
                buffer.append("/");
            }
            buffer.append("logout?_eventId=next&");
            buffer.append("RelayState");
            buffer.append("=");
            buffer.append(CommonUtils.urlEncode((String)((String)relayStateValue.get())));
            String redirectUrl = buffer.toString();
            logger.debug("Redirection url to the CAS server: {}", (Object)redirectUrl);
            throw RedirectionActionHelper.buildRedirectUrlAction((WebContext)context, (String)redirectUrl);
        }
    }
}

