/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import lombok.Generated;
import org.apereo.cas.client.proxy.ProxyGrantingTicketStorage;
import org.apereo.cas.client.ssl.HttpURLConnectionFactory;
import org.apereo.cas.client.util.PrivateKeyUtils;
import org.apereo.cas.client.validation.Cas10TicketValidator;
import org.apereo.cas.client.validation.Cas20ProxyTicketValidator;
import org.apereo.cas.client.validation.Cas20ServiceTicketValidator;
import org.apereo.cas.client.validation.Cas30ProxyTicketValidator;
import org.apereo.cas.client.validation.Cas30ServiceTicketValidator;
import org.apereo.cas.client.validation.ProxyList;
import org.apereo.cas.client.validation.Saml11TicketValidator;
import org.apereo.cas.client.validation.TicketValidator;
import org.pac4j.cas.client.CasProxyReceptor;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.cas.store.ProxyGrantingTicketStore;
import org.pac4j.core.client.config.BaseClientConfiguration;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.url.DefaultUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.util.CommonHelper;

public class CasConfiguration
extends BaseClientConfiguration {
    public static final String TICKET_PARAMETER = "ticket";
    public static final String SERVICE_PARAMETER = "service";
    public static final String LOGOUT_REQUEST_PARAMETER = "logoutRequest";
    public static final String SESSION_INDEX_TAG = "SessionIndex";
    public static final String RELAY_STATE_PARAMETER = "RelayState";
    private String encoding = StandardCharsets.UTF_8.name();
    private String loginUrl;
    private String prefixUrl;
    private String restUrl;
    private long timeTolerance = 1000L;
    private CasProtocol protocol = CasProtocol.CAS30;
    private boolean renew = false;
    private boolean gateway = false;
    private boolean acceptAnyProxy = false;
    private ProxyList allowedProxyChains = new ProxyList();
    private TicketValidator defaultTicketValidator;
    private CasProxyReceptor proxyReceptor;
    private UrlResolver urlResolver;
    private String postLogoutUrlParameter = "service";
    private Map<String, String> customParams = new HashMap<String, String>();
    private String method;
    private String privateKeyPath;
    private String privateKeyAlgorithm;
    private PrivateKey privateKey;
    private HostnameVerifier hostnameVerifier;
    private SSLSocketFactory sslSocketFactory;

    public CasConfiguration() {
    }

    public CasConfiguration(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public CasConfiguration(String loginUrl, CasProtocol protocol) {
        this.loginUrl = loginUrl;
        this.protocol = protocol;
    }

    public CasConfiguration(String loginUrl, String prefixUrl) {
        this.loginUrl = loginUrl;
        this.prefixUrl = prefixUrl;
    }

    protected void internalInit(boolean forceReinit) {
        if (CommonHelper.isBlank((String)this.loginUrl) && CommonHelper.isBlank((String)this.prefixUrl) && CommonHelper.isBlank((String)this.restUrl)) {
            throw new TechnicalException("loginUrl, prefixUrl and restUrl cannot be all blank");
        }
        if (this.urlResolver == null) {
            this.urlResolver = new DefaultUrlResolver();
        }
        this.initializeClientConfiguration();
        if (this.privateKeyPath != null) {
            String algo = Objects.requireNonNullElse(this.privateKeyAlgorithm, "RSA");
            this.privateKey = PrivateKeyUtils.createKey((String)this.privateKeyPath, (String)algo);
        }
    }

    protected void initializeClientConfiguration() {
        if (this.prefixUrl != null && !this.prefixUrl.endsWith("/")) {
            this.prefixUrl = this.prefixUrl + "/";
        }
        if (CommonHelper.isBlank((String)this.prefixUrl)) {
            this.prefixUrl = this.loginUrl.replaceFirst("/login$", "/");
        } else if (CommonHelper.isBlank((String)this.loginUrl)) {
            this.loginUrl = this.prefixUrl + "login";
        }
        if (CommonHelper.isBlank((String)this.restUrl)) {
            this.restUrl = this.prefixUrl;
            if (!this.restUrl.endsWith("/")) {
                this.restUrl = this.restUrl + "/";
            }
            this.restUrl = this.restUrl + "v1/tickets";
        }
    }

    public TicketValidator retrieveTicketValidator(WebContext context) {
        if (this.defaultTicketValidator != null) {
            return this.defaultTicketValidator;
        }
        if (this.protocol == CasProtocol.CAS10) {
            return this.buildCas10TicketValidator(context);
        }
        if (this.protocol == CasProtocol.CAS20) {
            return this.buildCas20TicketValidator(context);
        }
        if (this.protocol == CasProtocol.CAS20_PROXY) {
            return this.buildCas20ProxyTicketValidator(context);
        }
        if (this.protocol == CasProtocol.CAS30) {
            return this.buildCas30TicketValidator(context);
        }
        if (this.protocol == CasProtocol.CAS30_PROXY) {
            return this.buildCas30ProxyTicketValidator(context);
        }
        if (this.protocol == CasProtocol.SAML) {
            return this.buildSAMLTicketValidator(context);
        }
        throw new TechnicalException("Unable to initialize the TicketValidator for protocol: " + this.protocol);
    }

    protected TicketValidator buildSAMLTicketValidator(WebContext context) {
        Saml11TicketValidator saml11TicketValidator = new Saml11TicketValidator(this.computeFinalPrefixUrl(context));
        saml11TicketValidator.setTolerance(this.getTimeTolerance());
        saml11TicketValidator.setEncoding(this.encoding);
        saml11TicketValidator.setRenew(this.renew);
        this.getHttpURLConnectionFactory().ifPresent(arg_0 -> ((Saml11TicketValidator)saml11TicketValidator).setURLConnectionFactory(arg_0));
        return saml11TicketValidator;
    }

    protected void addPrivateKey(Cas20ServiceTicketValidator validator) {
        if (this.privateKey != null) {
            validator.setPrivateKey(this.privateKey);
        }
    }

    protected TicketValidator buildCas30ProxyTicketValidator(WebContext context) {
        Cas30ProxyTicketValidator cas30ProxyTicketValidator = new Cas30ProxyTicketValidator(this.computeFinalPrefixUrl(context));
        cas30ProxyTicketValidator.setEncoding(this.encoding);
        cas30ProxyTicketValidator.setRenew(this.renew);
        cas30ProxyTicketValidator.setAcceptAnyProxy(this.acceptAnyProxy);
        cas30ProxyTicketValidator.setAllowedProxyChains(this.allowedProxyChains);
        if (this.proxyReceptor != null) {
            cas30ProxyTicketValidator.setProxyCallbackUrl(this.proxyReceptor.computeFinalCallbackUrl(context));
            cas30ProxyTicketValidator.setProxyGrantingTicketStorage((ProxyGrantingTicketStorage)new ProxyGrantingTicketStore(this.proxyReceptor.getStore()));
        }
        this.addPrivateKey((Cas20ServiceTicketValidator)cas30ProxyTicketValidator);
        this.getHttpURLConnectionFactory().ifPresent(arg_0 -> ((Cas30ProxyTicketValidator)cas30ProxyTicketValidator).setURLConnectionFactory(arg_0));
        return cas30ProxyTicketValidator;
    }

    protected TicketValidator buildCas30TicketValidator(WebContext context) {
        Cas30ServiceTicketValidator cas30ServiceTicketValidator = new Cas30ServiceTicketValidator(this.computeFinalPrefixUrl(context));
        cas30ServiceTicketValidator.setEncoding(this.encoding);
        cas30ServiceTicketValidator.setRenew(this.renew);
        if (this.proxyReceptor != null) {
            cas30ServiceTicketValidator.setProxyCallbackUrl(this.proxyReceptor.computeFinalCallbackUrl(context));
            cas30ServiceTicketValidator.setProxyGrantingTicketStorage((ProxyGrantingTicketStorage)new ProxyGrantingTicketStore(this.proxyReceptor.getStore()));
        }
        this.addPrivateKey((Cas20ServiceTicketValidator)cas30ServiceTicketValidator);
        this.getHttpURLConnectionFactory().ifPresent(arg_0 -> ((Cas30ServiceTicketValidator)cas30ServiceTicketValidator).setURLConnectionFactory(arg_0));
        return cas30ServiceTicketValidator;
    }

    protected TicketValidator buildCas20ProxyTicketValidator(WebContext context) {
        Cas20ProxyTicketValidator cas20ProxyTicketValidator = new Cas20ProxyTicketValidator(this.computeFinalPrefixUrl(context));
        cas20ProxyTicketValidator.setEncoding(this.encoding);
        cas20ProxyTicketValidator.setRenew(this.renew);
        cas20ProxyTicketValidator.setAcceptAnyProxy(this.acceptAnyProxy);
        cas20ProxyTicketValidator.setAllowedProxyChains(this.allowedProxyChains);
        if (this.proxyReceptor != null) {
            cas20ProxyTicketValidator.setProxyCallbackUrl(this.proxyReceptor.computeFinalCallbackUrl(context));
            cas20ProxyTicketValidator.setProxyGrantingTicketStorage((ProxyGrantingTicketStorage)new ProxyGrantingTicketStore(this.proxyReceptor.getStore()));
        }
        this.addPrivateKey((Cas20ServiceTicketValidator)cas20ProxyTicketValidator);
        this.getHttpURLConnectionFactory().ifPresent(arg_0 -> ((Cas20ProxyTicketValidator)cas20ProxyTicketValidator).setURLConnectionFactory(arg_0));
        return cas20ProxyTicketValidator;
    }

    protected TicketValidator buildCas20TicketValidator(WebContext context) {
        Cas20ServiceTicketValidator cas20ServiceTicketValidator = new Cas20ServiceTicketValidator(this.computeFinalPrefixUrl(context));
        cas20ServiceTicketValidator.setEncoding(this.encoding);
        cas20ServiceTicketValidator.setRenew(this.renew);
        if (this.proxyReceptor != null) {
            cas20ServiceTicketValidator.setProxyCallbackUrl(this.proxyReceptor.computeFinalCallbackUrl(context));
            cas20ServiceTicketValidator.setProxyGrantingTicketStorage((ProxyGrantingTicketStorage)new ProxyGrantingTicketStore(this.proxyReceptor.getStore()));
        }
        this.addPrivateKey(cas20ServiceTicketValidator);
        this.getHttpURLConnectionFactory().ifPresent(arg_0 -> ((Cas20ServiceTicketValidator)cas20ServiceTicketValidator).setURLConnectionFactory(arg_0));
        return cas20ServiceTicketValidator;
    }

    protected TicketValidator buildCas10TicketValidator(WebContext context) {
        Cas10TicketValidator cas10TicketValidator = new Cas10TicketValidator(this.computeFinalPrefixUrl(context));
        cas10TicketValidator.setEncoding(this.encoding);
        cas10TicketValidator.setRenew(this.renew);
        this.getHttpURLConnectionFactory().ifPresent(arg_0 -> ((Cas10TicketValidator)cas10TicketValidator).setURLConnectionFactory(arg_0));
        return cas10TicketValidator;
    }

    public String computeFinalLoginUrl(WebContext context) {
        this.init();
        return this.urlResolver.compute(this.loginUrl, context);
    }

    public String computeFinalPrefixUrl(WebContext context) {
        this.init();
        return this.urlResolver.compute(this.prefixUrl, context);
    }

    public void setAllowedProxies(Iterable<String> allowedProxies) {
        ArrayList<String[]> proxyChains = new ArrayList<String[]>();
        for (String allowedProxyChain : allowedProxies) {
            String[] proxyChain = new String[]{allowedProxyChain};
            proxyChains.add(proxyChain);
        }
        this.allowedProxyChains = new ProxyList(proxyChains);
    }

    public String computeFinalRestUrl(WebContext context) {
        this.init();
        return this.urlResolver.compute(this.restUrl, context);
    }

    private Optional<HttpURLConnectionFactory> getHttpURLConnectionFactory() {
        if (this.sslSocketFactory == null && this.hostnameVerifier == null) {
            return Optional.empty();
        }
        HttpURLConnectionFactory factory = new HttpURLConnectionFactory(){
            private static final long serialVersionUID = 7296708420276819683L;

            public HttpURLConnection buildHttpURLConnection(URLConnection conn) {
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection httpsConnection = (HttpsURLConnection)conn;
                    if (CasConfiguration.this.getSslSocketFactory() != null) {
                        httpsConnection.setSSLSocketFactory(CasConfiguration.this.getSslSocketFactory());
                    }
                    if (CasConfiguration.this.getHostnameVerifier() != null) {
                        httpsConnection.setHostnameVerifier(CasConfiguration.this.getHostnameVerifier());
                    }
                }
                return (HttpURLConnection)conn;
            }
        };
        return Optional.of(factory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getEncoding() {
        return this.encoding;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLoginUrl() {
        return this.loginUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPrefixUrl() {
        return this.prefixUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRestUrl() {
        return this.restUrl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getTimeTolerance() {
        return this.timeTolerance;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasProtocol getProtocol() {
        return this.protocol;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isRenew() {
        return this.renew;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isGateway() {
        return this.gateway;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAcceptAnyProxy() {
        return this.acceptAnyProxy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ProxyList getAllowedProxyChains() {
        return this.allowedProxyChains;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TicketValidator getDefaultTicketValidator() {
        return this.defaultTicketValidator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasProxyReceptor getProxyReceptor() {
        return this.proxyReceptor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UrlResolver getUrlResolver() {
        return this.urlResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPostLogoutUrlParameter() {
        return this.postLogoutUrlParameter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, String> getCustomParams() {
        return this.customParams;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getMethod() {
        return this.method;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPrivateKeyAlgorithm() {
        return this.privateKeyAlgorithm;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setPrefixUrl(String prefixUrl) {
        this.prefixUrl = prefixUrl;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setRestUrl(String restUrl) {
        this.restUrl = restUrl;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setTimeTolerance(long timeTolerance) {
        this.timeTolerance = timeTolerance;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setProtocol(CasProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setRenew(boolean renew) {
        this.renew = renew;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setGateway(boolean gateway) {
        this.gateway = gateway;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setAcceptAnyProxy(boolean acceptAnyProxy) {
        this.acceptAnyProxy = acceptAnyProxy;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setAllowedProxyChains(ProxyList allowedProxyChains) {
        this.allowedProxyChains = allowedProxyChains;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setDefaultTicketValidator(TicketValidator defaultTicketValidator) {
        this.defaultTicketValidator = defaultTicketValidator;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setProxyReceptor(CasProxyReceptor proxyReceptor) {
        this.proxyReceptor = proxyReceptor;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setUrlResolver(UrlResolver urlResolver) {
        this.urlResolver = urlResolver;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setPostLogoutUrlParameter(String postLogoutUrlParameter) {
        this.postLogoutUrlParameter = postLogoutUrlParameter;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setCustomParams(Map<String, String> customParams) {
        this.customParams = customParams;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setMethod(String method) {
        this.method = method;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setPrivateKeyAlgorithm(String privateKeyAlgorithm) {
        this.privateKeyAlgorithm = privateKeyAlgorithm;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CasConfiguration(encoding=" + this.encoding + ", loginUrl=" + this.loginUrl + ", prefixUrl=" + this.prefixUrl + ", restUrl=" + this.restUrl + ", timeTolerance=" + this.timeTolerance + ", protocol=" + this.protocol + ", renew=" + this.renew + ", gateway=" + this.gateway + ", acceptAnyProxy=" + this.acceptAnyProxy + ", allowedProxyChains=" + this.allowedProxyChains + ", defaultTicketValidator=" + this.defaultTicketValidator + ", proxyReceptor=" + this.proxyReceptor + ", urlResolver=" + this.urlResolver + ", postLogoutUrlParameter=" + this.postLogoutUrlParameter + ", customParams=" + this.customParams + ", method=" + this.method + ", privateKeyPath=" + this.privateKeyPath + ", privateKeyAlgorithm=" + this.privateKeyAlgorithm + ", privateKey=" + this.privateKey + ", hostnameVerifier=" + this.hostnameVerifier + ", sslSocketFactory=" + this.sslSocketFactory + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withEncoding(String encoding) {
        return this.encoding == encoding ? this : new CasConfiguration(encoding, this.loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, this.protocol, this.renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withLoginUrl(String loginUrl) {
        return this.loginUrl == loginUrl ? this : new CasConfiguration(this.encoding, loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, this.protocol, this.renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withPrefixUrl(String prefixUrl) {
        return this.prefixUrl == prefixUrl ? this : new CasConfiguration(this.encoding, this.loginUrl, prefixUrl, this.restUrl, this.timeTolerance, this.protocol, this.renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withRestUrl(String restUrl) {
        return this.restUrl == restUrl ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, restUrl, this.timeTolerance, this.protocol, this.renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withTimeTolerance(long timeTolerance) {
        return this.timeTolerance == timeTolerance ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, this.restUrl, timeTolerance, this.protocol, this.renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withProtocol(CasProtocol protocol) {
        return this.protocol == protocol ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, protocol, this.renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withRenew(boolean renew) {
        return this.renew == renew ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, this.protocol, renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withGateway(boolean gateway) {
        return this.gateway == gateway ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, this.protocol, this.renew, gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withAcceptAnyProxy(boolean acceptAnyProxy) {
        return this.acceptAnyProxy == acceptAnyProxy ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, this.protocol, this.renew, this.gateway, acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withAllowedProxyChains(ProxyList allowedProxyChains) {
        return this.allowedProxyChains == allowedProxyChains ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, this.protocol, this.renew, this.gateway, this.acceptAnyProxy, allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withDefaultTicketValidator(TicketValidator defaultTicketValidator) {
        return this.defaultTicketValidator == defaultTicketValidator ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, this.protocol, this.renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withProxyReceptor(CasProxyReceptor proxyReceptor) {
        return this.proxyReceptor == proxyReceptor ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, this.protocol, this.renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withUrlResolver(UrlResolver urlResolver) {
        return this.urlResolver == urlResolver ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, this.protocol, this.renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withPostLogoutUrlParameter(String postLogoutUrlParameter) {
        return this.postLogoutUrlParameter == postLogoutUrlParameter ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, this.protocol, this.renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withCustomParams(Map<String, String> customParams) {
        return this.customParams == customParams ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, this.protocol, this.renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withMethod(String method) {
        return this.method == method ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, this.protocol, this.renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withPrivateKeyPath(String privateKeyPath) {
        return this.privateKeyPath == privateKeyPath ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, this.protocol, this.renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withPrivateKeyAlgorithm(String privateKeyAlgorithm) {
        return this.privateKeyAlgorithm == privateKeyAlgorithm ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, this.protocol, this.renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withPrivateKey(PrivateKey privateKey) {
        return this.privateKey == privateKey ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, this.protocol, this.renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, privateKey, this.hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withHostnameVerifier(HostnameVerifier hostnameVerifier) {
        return this.hostnameVerifier == hostnameVerifier ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, this.protocol, this.renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, hostnameVerifier, this.sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration withSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        return this.sslSocketFactory == sslSocketFactory ? this : new CasConfiguration(this.encoding, this.loginUrl, this.prefixUrl, this.restUrl, this.timeTolerance, this.protocol, this.renew, this.gateway, this.acceptAnyProxy, this.allowedProxyChains, this.defaultTicketValidator, this.proxyReceptor, this.urlResolver, this.postLogoutUrlParameter, this.customParams, this.method, this.privateKeyPath, this.privateKeyAlgorithm, this.privateKey, this.hostnameVerifier, sslSocketFactory);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration(String encoding, String loginUrl, String prefixUrl, String restUrl, long timeTolerance, CasProtocol protocol, boolean renew, boolean gateway, boolean acceptAnyProxy, ProxyList allowedProxyChains, TicketValidator defaultTicketValidator, CasProxyReceptor proxyReceptor, UrlResolver urlResolver, String postLogoutUrlParameter, Map<String, String> customParams, String method, String privateKeyPath, String privateKeyAlgorithm, PrivateKey privateKey, HostnameVerifier hostnameVerifier, SSLSocketFactory sslSocketFactory) {
        this.encoding = encoding;
        this.loginUrl = loginUrl;
        this.prefixUrl = prefixUrl;
        this.restUrl = restUrl;
        this.timeTolerance = timeTolerance;
        this.protocol = protocol;
        this.renew = renew;
        this.gateway = gateway;
        this.acceptAnyProxy = acceptAnyProxy;
        this.allowedProxyChains = allowedProxyChains;
        this.defaultTicketValidator = defaultTicketValidator;
        this.proxyReceptor = proxyReceptor;
        this.urlResolver = urlResolver;
        this.postLogoutUrlParameter = postLogoutUrlParameter;
        this.customParams = customParams;
        this.method = method;
        this.privateKeyPath = privateKeyPath;
        this.privateKeyAlgorithm = privateKeyAlgorithm;
        this.privateKey = privateKey;
        this.hostnameVerifier = hostnameVerifier;
        this.sslSocketFactory = sslSocketFactory;
    }
}

