/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.ldaptive;

import java.time.Duration;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.BindRequest;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionInitializer;
import org.ldaptive.Credential;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchExecutor;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchScope;
import org.ldaptive.ad.extended.FastBindOperation;
import org.ldaptive.auth.AuthenticationHandler;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.DnResolver;
import org.ldaptive.auth.EntryResolver;
import org.ldaptive.auth.FormatDnResolver;
import org.ldaptive.auth.PooledBindAuthenticationHandler;
import org.ldaptive.auth.PooledCompareAuthenticationHandler;
import org.ldaptive.auth.PooledSearchDnResolver;
import org.ldaptive.auth.PooledSearchEntryResolver;
import org.ldaptive.control.PasswordPolicyControl;
import org.ldaptive.control.RequestControl;
import org.ldaptive.pool.BindPassivator;
import org.ldaptive.pool.BlockingConnectionPool;
import org.ldaptive.pool.ClosePassivator;
import org.ldaptive.pool.ConnectionPool;
import org.ldaptive.pool.IdlePruneStrategy;
import org.ldaptive.pool.Passivator;
import org.ldaptive.pool.PoolConfig;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.pool.PruneStrategy;
import org.ldaptive.pool.SearchValidator;
import org.ldaptive.pool.Validator;
import org.ldaptive.provider.Provider;
import org.ldaptive.sasl.CramMd5Config;
import org.ldaptive.sasl.DigestMd5Config;
import org.ldaptive.sasl.ExternalConfig;
import org.ldaptive.sasl.GssApiConfig;
import org.ldaptive.sasl.SaslConfig;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.KeyStoreCredentialConfig;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.X509CredentialConfig;
import org.pac4j.config.ldaptive.AbstractLdapProperties;
import org.pac4j.config.ldaptive.LdapAuthenticationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdaptiveAuthenticatorBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdaptiveAuthenticatorBuilder.class);

    protected LdaptiveAuthenticatorBuilder() {
    }

    public static Authenticator getAuthenticator(LdapAuthenticationProperties l) {
        if (l.getType() == LdapAuthenticationProperties.AuthenticationTypes.AD) {
            LOGGER.debug("Creating active directory authenticator for {}", (Object)l.getLdapUrl());
            return LdaptiveAuthenticatorBuilder.getActiveDirectoryAuthenticator(l);
        }
        if (l.getType() == LdapAuthenticationProperties.AuthenticationTypes.DIRECT) {
            LOGGER.debug("Creating direct-bind authenticator for {}", (Object)l.getLdapUrl());
            return LdaptiveAuthenticatorBuilder.getDirectBindAuthenticator(l);
        }
        if (l.getType() == LdapAuthenticationProperties.AuthenticationTypes.SASL) {
            LOGGER.debug("Creating SASL authenticator for {}", (Object)l.getLdapUrl());
            return LdaptiveAuthenticatorBuilder.getSaslAuthenticator(l);
        }
        if (l.getType() == LdapAuthenticationProperties.AuthenticationTypes.AUTHENTICATED) {
            LOGGER.debug("Creating authenticated authenticator for {}", (Object)l.getLdapUrl());
            return LdaptiveAuthenticatorBuilder.getAuthenticatedOrAnonSearchAuthenticator(l);
        }
        LOGGER.debug("Creating anonymous authenticator for {}", (Object)l.getLdapUrl());
        return LdaptiveAuthenticatorBuilder.getAuthenticatedOrAnonSearchAuthenticator(l);
    }

    private static Authenticator getSaslAuthenticator(LdapAuthenticationProperties l) {
        PooledSearchDnResolver resolver = new PooledSearchDnResolver();
        resolver.setBaseDn(l.getBaseDn());
        resolver.setSubtreeSearch(l.isSubtreeSearch());
        resolver.setAllowMultipleDns(l.isAllowMultipleDns());
        resolver.setConnectionFactory(LdaptiveAuthenticatorBuilder.newPooledConnectionFactory(l));
        resolver.setUserFilter(l.getUserFilter());
        return new Authenticator((DnResolver)resolver, (AuthenticationHandler)LdaptiveAuthenticatorBuilder.getPooledBindAuthenticationHandler(l));
    }

    private static Authenticator getAuthenticatedOrAnonSearchAuthenticator(LdapAuthenticationProperties l) {
        PooledSearchDnResolver resolver = new PooledSearchDnResolver();
        resolver.setBaseDn(l.getBaseDn());
        resolver.setSubtreeSearch(l.isSubtreeSearch());
        resolver.setAllowMultipleDns(l.isAllowMultipleDns());
        resolver.setConnectionFactory(LdaptiveAuthenticatorBuilder.newPooledConnectionFactory(l));
        resolver.setUserFilter(l.getUserFilter());
        Authenticator auth = StringUtils.isBlank((CharSequence)l.getPrincipalAttributePassword()) ? new Authenticator((DnResolver)resolver, (AuthenticationHandler)LdaptiveAuthenticatorBuilder.getPooledBindAuthenticationHandler(l)) : new Authenticator((DnResolver)resolver, (AuthenticationHandler)LdaptiveAuthenticatorBuilder.getPooledCompareAuthenticationHandler(l));
        if (l.isEnhanceWithEntryResolver()) {
            auth.setEntryResolver(LdaptiveAuthenticatorBuilder.newSearchEntryResolver(l));
        }
        return auth;
    }

    private static Authenticator getDirectBindAuthenticator(LdapAuthenticationProperties l) {
        if (StringUtils.isBlank((CharSequence)l.getDnFormat())) {
            throw new IllegalArgumentException("Dn format cannot be empty/blank for direct bind authentication");
        }
        FormatDnResolver resolver = new FormatDnResolver(l.getDnFormat());
        Authenticator authenticator = new Authenticator((DnResolver)resolver, (AuthenticationHandler)LdaptiveAuthenticatorBuilder.getPooledBindAuthenticationHandler(l));
        if (l.isEnhanceWithEntryResolver()) {
            authenticator.setEntryResolver(LdaptiveAuthenticatorBuilder.newSearchEntryResolver(l));
        }
        return authenticator;
    }

    private static Authenticator getActiveDirectoryAuthenticator(LdapAuthenticationProperties l) {
        if (StringUtils.isBlank((CharSequence)l.getDnFormat())) {
            throw new IllegalArgumentException("Dn format cannot be empty/blank for active directory authentication");
        }
        FormatDnResolver resolver = new FormatDnResolver(l.getDnFormat());
        Authenticator authn = new Authenticator((DnResolver)resolver, (AuthenticationHandler)LdaptiveAuthenticatorBuilder.getPooledBindAuthenticationHandler(l));
        if (l.isEnhanceWithEntryResolver()) {
            authn.setEntryResolver(LdaptiveAuthenticatorBuilder.newSearchEntryResolver(l));
        }
        return authn;
    }

    private static PooledBindAuthenticationHandler getPooledBindAuthenticationHandler(LdapAuthenticationProperties l) {
        PooledBindAuthenticationHandler handler = new PooledBindAuthenticationHandler(LdaptiveAuthenticatorBuilder.newPooledConnectionFactory(l));
        handler.setAuthenticationControls(new RequestControl[]{new PasswordPolicyControl()});
        return handler;
    }

    private static PooledCompareAuthenticationHandler getPooledCompareAuthenticationHandler(LdapAuthenticationProperties l) {
        PooledCompareAuthenticationHandler handler = new PooledCompareAuthenticationHandler(LdaptiveAuthenticatorBuilder.newPooledConnectionFactory(l));
        handler.setPasswordAttribute(l.getPrincipalAttributePassword());
        return handler;
    }

    public static EntryResolver newSearchEntryResolver(LdapAuthenticationProperties l) {
        PooledSearchEntryResolver entryResolver = new PooledSearchEntryResolver();
        entryResolver.setBaseDn(l.getBaseDn());
        entryResolver.setUserFilter(l.getUserFilter());
        entryResolver.setSubtreeSearch(l.isSubtreeSearch());
        entryResolver.setConnectionFactory(LdaptiveAuthenticatorBuilder.newPooledConnectionFactory(l));
        return entryResolver;
    }

    public static ConnectionConfig newConnectionConfig(AbstractLdapProperties l) {
        X509CredentialConfig cfg;
        ConnectionConfig cc = new ConnectionConfig();
        String urls = Arrays.stream(l.getLdapUrl().split(",")).collect(Collectors.joining(" "));
        LOGGER.debug("Transformed LDAP urls from [{}] to [{}]", (Object)l.getLdapUrl(), (Object)urls);
        cc.setLdapUrl(urls);
        cc.setUseSSL(l.isUseSsl());
        cc.setUseStartTLS(l.isUseStartTls());
        cc.setConnectTimeout(LdaptiveAuthenticatorBuilder.newDuration(l.getConnectTimeout()));
        if (l.getTrustCertificates() != null) {
            cfg = new X509CredentialConfig();
            cfg.setTrustCertificates(l.getTrustCertificates());
            cc.setSslConfig(new SslConfig((CredentialConfig)cfg));
        } else if (l.getKeystore() != null) {
            cfg = new KeyStoreCredentialConfig();
            cfg.setKeyStore(l.getKeystore());
            cfg.setKeyStorePassword(l.getKeystorePassword());
            cfg.setKeyStoreType(l.getKeystoreType());
            cc.setSslConfig(new SslConfig((CredentialConfig)cfg));
        } else {
            cc.setSslConfig(new SslConfig());
        }
        if (l.getSaslMechanism() != null) {
            DigestMd5Config sc;
            BindConnectionInitializer bc = new BindConnectionInitializer();
            switch (l.getSaslMechanism()) {
                case DIGEST_MD5: {
                    sc = new DigestMd5Config();
                    sc.setRealm(l.getSaslRealm());
                    break;
                }
                case CRAM_MD5: {
                    sc = new CramMd5Config();
                    break;
                }
                case EXTERNAL: {
                    sc = new ExternalConfig();
                    break;
                }
                case GSSAPI: {
                    sc = new GssApiConfig();
                    ((GssApiConfig)sc).setRealm(l.getSaslRealm());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown SASL mechanism " + l.getSaslMechanism().name());
                }
            }
            sc.setAuthorizationId(l.getSaslAuthorizationId());
            sc.setMutualAuthentication(l.getSaslMutualAuth());
            sc.setQualityOfProtection(l.getSaslQualityOfProtection());
            sc.setSecurityStrength(l.getSaslSecurityStrength());
            bc.setBindSaslConfig((SaslConfig)sc);
            cc.setConnectionInitializer((ConnectionInitializer)bc);
        } else if (StringUtils.equals((CharSequence)l.getBindCredential(), (CharSequence)"*") && StringUtils.equals((CharSequence)l.getBindDn(), (CharSequence)"*")) {
            cc.setConnectionInitializer((ConnectionInitializer)new FastBindOperation.FastBindConnectionInitializer());
        } else if (StringUtils.isNotBlank((CharSequence)l.getBindDn()) && StringUtils.isNotBlank((CharSequence)l.getBindCredential())) {
            cc.setConnectionInitializer((ConnectionInitializer)new BindConnectionInitializer(l.getBindDn(), new Credential(l.getBindCredential())));
        }
        return cc;
    }

    public static PoolConfig newPoolConfig(AbstractLdapProperties l) {
        PoolConfig pc = new PoolConfig();
        pc.setMinPoolSize(l.getMinPoolSize());
        pc.setMaxPoolSize(l.getMaxPoolSize());
        pc.setValidateOnCheckOut(l.isValidateOnCheckout());
        pc.setValidatePeriodically(l.isValidatePeriodically());
        pc.setValidatePeriod(LdaptiveAuthenticatorBuilder.newDuration(l.getValidatePeriod()));
        return pc;
    }

    public static DefaultConnectionFactory newConnectionFactory(AbstractLdapProperties l) {
        ConnectionConfig cc = LdaptiveAuthenticatorBuilder.newConnectionConfig(l);
        DefaultConnectionFactory bindCf = new DefaultConnectionFactory(cc);
        if (l.getProviderClass() != null) {
            try {
                Class clazz = ClassUtils.getClass((String)l.getProviderClass());
                bindCf.setProvider((Provider)Provider.class.cast(clazz.newInstance()));
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return bindCf;
    }

    public static ConnectionPool newBlockingConnectionPool(AbstractLdapProperties l) {
        DefaultConnectionFactory bindCf = LdaptiveAuthenticatorBuilder.newConnectionFactory(l);
        PoolConfig pc = LdaptiveAuthenticatorBuilder.newPoolConfig(l);
        BlockingConnectionPool cp = new BlockingConnectionPool(pc, bindCf);
        cp.setBlockWaitTime(LdaptiveAuthenticatorBuilder.newDuration(l.getBlockWaitTime()));
        cp.setPoolConfig(pc);
        IdlePruneStrategy strategy = new IdlePruneStrategy();
        strategy.setIdleTime(LdaptiveAuthenticatorBuilder.newDuration(l.getIdleTime()));
        strategy.setPrunePeriod(LdaptiveAuthenticatorBuilder.newDuration(l.getPrunePeriod()));
        cp.setPruneStrategy((PruneStrategy)strategy);
        cp.setValidator((Validator)new SearchValidator());
        cp.setFailFastInitialize(l.isFailFast());
        if (StringUtils.isNotBlank((CharSequence)l.getPoolPassivator())) {
            AbstractLdapProperties.LdapConnectionPoolPassivator pass = AbstractLdapProperties.LdapConnectionPoolPassivator.valueOf(l.getPoolPassivator().toUpperCase());
            switch (pass) {
                case CLOSE: {
                    cp.setPassivator((Passivator)new ClosePassivator());
                    break;
                }
                case BIND: {
                    LOGGER.debug("Creating a bind passivator instance for the connection pool");
                    BindRequest bindRequest = new BindRequest();
                    bindRequest.setDn(l.getBindDn());
                    bindRequest.setCredential(new Credential(l.getBindCredential()));
                    cp.setPassivator((Passivator)new BindPassivator(bindRequest));
                    break;
                }
            }
        }
        LOGGER.debug("Initializing ldap connection pool for {} and bindDn {}", (Object)l.getLdapUrl(), (Object)l.getBindDn());
        cp.initialize();
        return cp;
    }

    public static PooledConnectionFactory newPooledConnectionFactory(AbstractLdapProperties l) {
        ConnectionPool cp = LdaptiveAuthenticatorBuilder.newBlockingConnectionPool(l);
        return new PooledConnectionFactory(cp);
    }

    public static Duration newDuration(long length) {
        return Duration.ofSeconds(length);
    }

    public static SearchRequest newSearchRequest(String baseDn, SearchFilter filter) {
        SearchRequest sr = new SearchRequest(baseDn, filter);
        sr.setBinaryAttributes(ReturnAttributes.ALL_USER.value());
        sr.setReturnAttributes(ReturnAttributes.ALL_USER.value());
        sr.setSearchScope(SearchScope.SUBTREE);
        return sr;
    }

    public static SearchFilter newSearchFilter(String filterQuery, String ... params) {
        SearchFilter filter = new SearchFilter();
        filter.setFilter(filterQuery);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (filter.getFilter().contains("{" + i + "}")) {
                    filter.setParameter(i, (Object)params[i]);
                    continue;
                }
                filter.setParameter("user", (Object)params[i]);
            }
        }
        LOGGER.debug("Constructed LDAP search filter [{}]", (Object)filter.format());
        return filter;
    }

    public static SearchExecutor newSearchExecutor(String baseDn, String filterQuery, String ... params) {
        SearchExecutor executor = new SearchExecutor();
        executor.setBaseDn(baseDn);
        executor.setSearchFilter(LdaptiveAuthenticatorBuilder.newSearchFilter(filterQuery, params));
        executor.setReturnAttributes(ReturnAttributes.ALL.value());
        executor.setSearchScope(SearchScope.SUBTREE);
        return executor;
    }
}

