/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.gae.client;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import org.pac4j.core.client.ClientType;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.gae.credentials.GaeUserCredentials;
import org.pac4j.gae.profile.GaeUserServiceProfile;

public class GaeUserServiceClient
extends IndirectClient<GaeUserCredentials, GaeUserServiceProfile> {
    UserService service;
    String authDomain = null;

    public GaeUserServiceClient() {
        this.setName("GaeUserServiceClient");
    }

    protected IndirectClient<GaeUserCredentials, GaeUserServiceProfile> newClient() {
        GaeUserServiceClient gaeUserServiceClient = new GaeUserServiceClient();
        gaeUserServiceClient.setAuthDomain(this.authDomain);
        return gaeUserServiceClient;
    }

    protected boolean isDirectRedirection() {
        return true;
    }

    protected RedirectAction retrieveRedirectAction(WebContext context) {
        String destinationUrl = this.computeFinalCallbackUrl(context);
        String loginUrl = this.authDomain == null ? this.service.createLoginURL(destinationUrl) : this.service.createLoginURL(destinationUrl, this.authDomain);
        return RedirectAction.redirect((String)loginUrl);
    }

    protected GaeUserCredentials retrieveCredentials(WebContext context) throws RequiresHttpAction {
        GaeUserCredentials credentials = new GaeUserCredentials();
        credentials.setUser(this.service.getCurrentUser());
        return credentials;
    }

    protected GaeUserServiceProfile retrieveUserProfile(GaeUserCredentials credentials, WebContext context) {
        User user = credentials.getUser();
        if (user != null) {
            GaeUserServiceProfile gaeUserProfile = new GaeUserServiceProfile();
            gaeUserProfile.setId(user.getEmail());
            gaeUserProfile.addAttribute("email", user.getEmail());
            gaeUserProfile.addAttribute("display_name", user.getNickname());
            if (this.service.isUserAdmin()) {
                gaeUserProfile.addRole("GLOBAL_ADMIN");
            }
            return gaeUserProfile;
        }
        return null;
    }

    public ClientType getClientType() {
        return ClientType.GAE_PROVIDER;
    }

    protected void internalInit(WebContext context) {
        this.service = UserServiceFactory.getUserService();
        CommonHelper.assertNotBlank((String)"callbackUrl", (String)this.callbackUrl);
    }

    public void setAuthDomain(String authDomain) {
        this.authDomain = authDomain;
    }

    public String getAuthDomain() {
        return this.authDomain;
    }
}

