/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.indirect;

import org.pac4j.core.client.ClientType;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.client.indirect.IndirectHttpClient;
import org.pac4j.http.credentials.UsernamePasswordCredentials;
import org.pac4j.http.credentials.authenticator.UsernamePasswordAuthenticator;
import org.pac4j.http.credentials.extractor.FormExtractor;
import org.pac4j.http.profile.creator.ProfileCreator;

public class FormClient
extends IndirectHttpClient<UsernamePasswordCredentials> {
    private String loginUrl;
    public static final String ERROR_PARAMETER = "error";
    public static final String MISSING_FIELD_ERROR = "missing_field";
    public static final String DEFAULT_USERNAME_PARAMETER = "username";
    private String usernameParameter = "username";
    public static final String DEFAULT_PASSWORD_PARAMETER = "password";
    private String passwordParameter = "password";

    public FormClient() {
    }

    public FormClient(String loginUrl) {
        this.setLoginUrl(loginUrl);
    }

    public FormClient(String loginUrl, UsernamePasswordAuthenticator usernamePasswordAuthenticator) {
        this.setLoginUrl(loginUrl);
        this.setAuthenticator(usernamePasswordAuthenticator);
    }

    public FormClient(String loginUrl, UsernamePasswordAuthenticator usernamePasswordAuthenticator, ProfileCreator profileCreator) {
        this.setLoginUrl(loginUrl);
        this.setAuthenticator(usernamePasswordAuthenticator);
        this.setProfileCreator(profileCreator);
    }

    protected IndirectHttpClient<UsernamePasswordCredentials> newClient() {
        FormClient newClient = new FormClient();
        newClient.setLoginUrl(this.loginUrl);
        newClient.setUsernameParameter(this.usernameParameter);
        newClient.setPasswordParameter(this.passwordParameter);
        return newClient;
    }

    @Override
    protected void internalInit(WebContext context) {
        this.extractor = new FormExtractor(this.usernameParameter, this.passwordParameter, this.getName());
        super.internalInit(context);
        CommonHelper.assertNotBlank((String)"loginUrl", (String)this.loginUrl);
        this.initializeClientConfiguration(context);
    }

    protected void initializeClientConfiguration(WebContext context) {
        this.loginUrl = this.callbackUrlResolver.compute(this.loginUrl, context);
    }

    protected RedirectAction retrieveRedirectAction(WebContext context) {
        return RedirectAction.redirect((String)this.loginUrl);
    }

    protected UsernamePasswordCredentials retrieveCredentials(WebContext context) throws RequiresHttpAction {
        UsernamePasswordCredentials credentials;
        String username = context.getRequestParameter(this.usernameParameter);
        try {
            credentials = (UsernamePasswordCredentials)((Object)this.extractor.extract(context));
            this.logger.debug("usernamePasswordCredentials : {}", (Object)credentials);
            if (credentials == null) {
                throw this.handleInvalidCredentials(context, username, "Username and password cannot be blank -> return to the form with error", MISSING_FIELD_ERROR, 401);
            }
            this.getAuthenticator().validate(credentials);
        }
        catch (CredentialsException e) {
            throw this.handleInvalidCredentials(context, username, "Credentials validation fails -> return to the form with error", this.computeErrorMessage((TechnicalException)e), 403);
        }
        return credentials;
    }

    private RequiresHttpAction handleInvalidCredentials(WebContext context, String username, String message, String errorMessage, int errorCode) throws RequiresHttpAction {
        if (this.getAjaxRequestResolver().isAjax(context)) {
            this.logger.info("AJAX request detected -> returning " + errorCode);
            return RequiresHttpAction.status((String)("AJAX request -> " + errorCode), (int)errorCode, (WebContext)context);
        }
        String redirectionUrl = CommonHelper.addParameter((String)this.loginUrl, (String)this.usernameParameter, (String)username);
        redirectionUrl = CommonHelper.addParameter((String)redirectionUrl, (String)ERROR_PARAMETER, (String)errorMessage);
        this.logger.debug("redirectionUrl: {}", (Object)redirectionUrl);
        this.logger.debug(message);
        return RequiresHttpAction.redirect((String)message, (WebContext)context, (String)redirectionUrl);
    }

    protected String computeErrorMessage(TechnicalException e) {
        return e.getClass().getSimpleName();
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"callbackUrl", this.callbackUrl, "name", this.getName(), "loginUrl", this.loginUrl, "usernameParameter", this.usernameParameter, "passwordParameter", this.passwordParameter, "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }

    protected boolean isDirectRedirection() {
        return true;
    }

    public ClientType getClientType() {
        return ClientType.FORM_BASED;
    }
}

