/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.indirect;

import org.pac4j.core.client.ClientType;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.client.indirect.IndirectHttpClient;
import org.pac4j.http.credentials.UsernamePasswordCredentials;
import org.pac4j.http.credentials.authenticator.UsernamePasswordAuthenticator;
import org.pac4j.http.credentials.extractor.BasicAuthExtractor;
import org.pac4j.http.profile.creator.ProfileCreator;

public class IndirectBasicAuthClient
extends IndirectHttpClient<UsernamePasswordCredentials> {
    private String realmName = "authentication required";

    public IndirectBasicAuthClient() {
    }

    public IndirectBasicAuthClient(UsernamePasswordAuthenticator usernamePasswordAuthenticator) {
        this.setAuthenticator(usernamePasswordAuthenticator);
    }

    public IndirectBasicAuthClient(UsernamePasswordAuthenticator usernamePasswordAuthenticator, ProfileCreator profileCreator) {
        this.setAuthenticator(usernamePasswordAuthenticator);
        this.setProfileCreator(profileCreator);
    }

    @Override
    protected void internalInit(WebContext context) {
        this.extractor = new BasicAuthExtractor(this.getName());
        super.internalInit(context);
        CommonHelper.assertNotBlank((String)"callbackUrl", (String)this.callbackUrl);
        CommonHelper.assertNotBlank((String)"realmName", (String)this.realmName);
    }

    public IndirectBasicAuthClient clone() {
        IndirectBasicAuthClient newClient = (IndirectBasicAuthClient)super.clone();
        newClient.setRealmName(this.realmName);
        return newClient;
    }

    protected IndirectBasicAuthClient newClient() {
        return new IndirectBasicAuthClient();
    }

    protected RedirectAction retrieveRedirectAction(WebContext context) {
        return RedirectAction.redirect((String)this.computeFinalCallbackUrl(context));
    }

    protected UsernamePasswordCredentials retrieveCredentials(WebContext context) throws RequiresHttpAction {
        UsernamePasswordCredentials credentials;
        try {
            credentials = (UsernamePasswordCredentials)((Object)this.extractor.extract(context));
            this.logger.debug("credentials : {}", (Object)credentials);
            if (credentials == null) {
                throw RequiresHttpAction.unauthorized((String)"Requires authentication", (WebContext)context, (String)this.realmName);
            }
            this.getAuthenticator().validate(credentials);
        }
        catch (CredentialsException e) {
            throw RequiresHttpAction.unauthorized((String)"Requires authentication", (WebContext)context, (String)this.realmName);
        }
        return credentials;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"callbackUrl", this.callbackUrl, "name", this.getName(), "realmName", this.realmName, "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }

    protected boolean isDirectRedirection() {
        return true;
    }

    public ClientType getClientType() {
        return ClientType.BASICAUTH_BASED;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }
}

