/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.indirect;

import java.util.Optional;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.credentials.extractor.FormExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;

public class FormClient
extends IndirectClient {
    private String loginUrl;
    public static final String ERROR_PARAMETER = "error";
    public static final String MISSING_FIELD_ERROR = "missing_field";
    private String usernameParameter = "username";
    private String passwordParameter = "password";

    public FormClient() {
    }

    public FormClient(String loginUrl, Authenticator usernamePasswordAuthenticator) {
        this.loginUrl = loginUrl;
        this.defaultAuthenticator(usernamePasswordAuthenticator);
    }

    public FormClient(String loginUrl, String usernameParameter, String passwordParameter, Authenticator usernamePasswordAuthenticator) {
        this.loginUrl = loginUrl;
        this.usernameParameter = usernameParameter;
        this.passwordParameter = passwordParameter;
        this.defaultAuthenticator(usernamePasswordAuthenticator);
    }

    public FormClient(String loginUrl, Authenticator usernamePasswordAuthenticator, ProfileCreator profileCreator) {
        this.loginUrl = loginUrl;
        this.defaultAuthenticator(usernamePasswordAuthenticator);
        this.defaultProfileCreator(profileCreator);
    }

    protected void internalInit() {
        CommonHelper.assertNotBlank((String)"loginUrl", (String)this.loginUrl);
        CommonHelper.assertNotBlank((String)"usernameParameter", (String)this.usernameParameter);
        CommonHelper.assertNotBlank((String)"passwordParameter", (String)this.passwordParameter);
        this.defaultRedirectionActionBuilder((ctx, session) -> {
            String finalLoginUrl = this.getUrlResolver().compute(this.loginUrl, ctx);
            return Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)ctx, (String)finalLoginUrl));
        });
        this.defaultCredentialsExtractor((CredentialsExtractor)new FormExtractor(this.usernameParameter, this.passwordParameter));
    }

    protected Optional<Credentials> retrieveCredentials(WebContext context, SessionStore sessionStore) {
        Optional credentials;
        CommonHelper.assertNotNull((String)"credentialsExtractor", (Object)this.getCredentialsExtractor());
        CommonHelper.assertNotNull((String)"authenticator", (Object)this.getAuthenticator());
        String username = context.getRequestParameter(this.usernameParameter).orElse(null);
        try {
            credentials = this.getCredentialsExtractor().extract(context, sessionStore);
            this.logger.debug("usernamePasswordCredentials: {}", (Object)credentials);
            if (!credentials.isPresent()) {
                throw this.handleInvalidCredentials(context, sessionStore, username, "Username and password cannot be blank -> return to the form with error", MISSING_FIELD_ERROR);
            }
            this.getAuthenticator().validate((Credentials)credentials.get(), context, sessionStore);
        }
        catch (CredentialsException e) {
            throw this.handleInvalidCredentials(context, sessionStore, username, "Credentials validation fails -> return to the form with error", this.computeErrorMessage((Exception)((Object)e)));
        }
        return credentials;
    }

    protected HttpAction handleInvalidCredentials(WebContext context, SessionStore sessionStore, String username, String message, String errorMessage) {
        if (this.getAjaxRequestResolver().isAjax(context, sessionStore)) {
            this.logger.info("AJAX request detected -> returning 401");
            return HttpActionHelper.buildUnauthenticatedAction((WebContext)context);
        }
        String redirectionUrl = CommonHelper.addParameter((String)this.loginUrl, (String)this.usernameParameter, (String)username);
        redirectionUrl = CommonHelper.addParameter((String)redirectionUrl, (String)ERROR_PARAMETER, (String)errorMessage);
        this.logger.debug("redirectionUrl: {}", (Object)redirectionUrl);
        return HttpActionHelper.buildRedirectUrlAction((WebContext)context, (String)redirectionUrl);
    }

    protected String computeErrorMessage(Exception e) {
        return e.getClass().getSimpleName();
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"callbackUrl", this.callbackUrl, "name", this.getName(), "loginUrl", this.loginUrl, "usernameParameter", this.usernameParameter, "passwordParameter", this.passwordParameter, "redirectionActionBuilder", this.getRedirectionActionBuilder(), "extractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }
}

