/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.extractor;

import java.util.Collection;
import java.util.Optional;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.util.CommonHelper;

public class CookieExtractor
implements CredentialsExtractor {
    private final String cookieName;

    public CookieExtractor(String cookieName) {
        this.cookieName = cookieName;
    }

    public Optional<Credentials> extract(WebContext context, SessionStore sessionStore) {
        Collection col = context.getRequestCookies();
        for (Cookie c : col) {
            if (!c.getName().equals(this.cookieName)) continue;
            return Optional.of(new TokenCredentials(c.getValue()));
        }
        return Optional.empty();
    }

    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), (Object[])new Object[]{"cookieName", this.cookieName});
    }
}

