/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.direct;

import org.pac4j.core.client.DirectClient;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.credentials.extractor.ParameterExtractor;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;

public class ParameterClient
extends DirectClient {
    private String parameterName = "";
    private boolean supportGetRequest = false;
    private boolean supportPostRequest = true;

    public ParameterClient() {
    }

    public ParameterClient(String parameterName, Authenticator tokenAuthenticator) {
        this.parameterName = parameterName;
        this.defaultAuthenticator(tokenAuthenticator);
    }

    public ParameterClient(String parameterName, ProfileCreator profileCreator) {
        this.parameterName = parameterName;
        this.defaultAuthenticator(Authenticator.ALWAYS_VALIDATE);
        this.defaultProfileCreator(profileCreator);
    }

    public ParameterClient(String parameterName, Authenticator tokenAuthenticator, ProfileCreator profileCreator) {
        this.parameterName = parameterName;
        this.defaultAuthenticator(tokenAuthenticator);
        this.defaultProfileCreator(profileCreator);
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank((String)"parameterName", (String)this.parameterName);
        this.defaultCredentialsExtractor((CredentialsExtractor)new ParameterExtractor(this.parameterName, this.supportGetRequest, this.supportPostRequest));
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public boolean isSupportGetRequest() {
        return this.supportGetRequest;
    }

    public void setSupportGetRequest(boolean supportGetRequest) {
        this.supportGetRequest = supportGetRequest;
    }

    public boolean isSupportPostRequest() {
        return this.supportPostRequest;
    }

    public void setSupportPostRequest(boolean supportPostRequest) {
        this.supportPostRequest = supportPostRequest;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "parameterName", this.parameterName, "supportGetRequest", this.supportGetRequest, "supportPostRequest", this.supportPostRequest, "extractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }
}

