/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.extractor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;

public class CookieExtractor
implements CredentialsExtractor {
    private final String cookieName;

    public CookieExtractor(String cookieName) {
        this.cookieName = cookieName;
    }

    public Optional<Credentials> extract(CallContext ctx) {
        Collection col = ctx.webContext().getRequestCookies();
        for (Cookie c : col) {
            if (!c.getName().equals(this.cookieName)) continue;
            return Optional.of(new TokenCredentials(c.getValue()));
        }
        return Optional.empty();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CookieExtractor(cookieName=" + this.cookieName + ")";
    }
}

