/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.extractor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.util.CommonHelper;

public class IpExtractor
implements CredentialsExtractor {
    private List<String> alternateIpHeaders = Collections.emptyList();
    private String proxyIp = "";

    public IpExtractor() {
    }

    public IpExtractor(String ... alternateIpHeaders) {
        this.alternateIpHeaders = Arrays.asList(alternateIpHeaders);
    }

    public Optional<Credentials> extract(CallContext ctx) {
        Optional<String> ip;
        WebContext webContext = ctx.webContext();
        if (this.alternateIpHeaders.isEmpty()) {
            ip = Optional.ofNullable(webContext.getRemoteAddr());
        } else {
            String requestSourceIp = webContext.getRemoteAddr();
            ip = this.proxyIp.isEmpty() ? this.ipFromHeaders(webContext) : (this.proxyIp.equals(requestSourceIp) ? this.ipFromHeaders(webContext) : Optional.empty());
        }
        if (ip.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new TokenCredentials(ip.get()));
    }

    private Optional<String> ipFromHeaders(WebContext context) {
        for (String header : this.alternateIpHeaders) {
            Optional ip = context.getRequestHeader(header);
            if (!ip.isPresent() || ((String)ip.get()).isEmpty()) continue;
            return ip;
        }
        return Optional.empty();
    }

    public void setProxyIp(String proxyIp) {
        this.proxyIp = proxyIp == null ? "" : proxyIp;
    }

    public void setAlternateIpHeaders(String ... alternateIpHeaders) {
        CommonHelper.assertNotNull((String)"alternateIpHeaders", (Object)alternateIpHeaders);
        this.alternateIpHeaders = Arrays.asList(alternateIpHeaders);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<String> getAlternateIpHeaders() {
        return this.alternateIpHeaders;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "IpExtractor(alternateIpHeaders=" + String.valueOf(this.alternateIpHeaders) + ", proxyIp=" + this.proxyIp + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getProxyIp() {
        return this.proxyIp;
    }
}

