/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.kerberos.credentials.authenticator;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.kerberos.credentials.KerberosCredentials;
import org.pac4j.kerberos.credentials.authenticator.KerberosTicketValidation;
import org.pac4j.kerberos.credentials.authenticator.KerberosTicketValidator;
import org.pac4j.kerberos.profile.KerberosProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthenticator
implements Authenticator<KerberosCredentials> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected KerberosTicketValidator ticketValidator;

    public KerberosAuthenticator(KerberosTicketValidator ticketValidator) {
        CommonHelper.assertNotNull((String)"ticketValidator", (Object)ticketValidator);
        this.ticketValidator = ticketValidator;
    }

    public void validate(KerberosCredentials credentials, WebContext context) {
        this.logger.trace("Try to validate Kerberos Token:" + credentials.getKerberosTicketAsString());
        KerberosTicketValidation ticketValidation = this.ticketValidator.validateTicket(credentials.getKerberosTicket());
        this.logger.debug("Kerberos Token validated");
        String subject = ticketValidation.username();
        this.logger.debug("Succesfully validated " + subject);
        KerberosProfile profile = new KerberosProfile(ticketValidation.getGssContext());
        profile.setId(subject);
        credentials.setUserProfile(profile);
    }
}

