/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.kerberos.credentials.extractor;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.kerberos.credentials.KerberosCredentials;

public class KerberosExtractor
implements CredentialsExtractor<KerberosCredentials> {
    public Optional<KerberosCredentials> extract(WebContext context) {
        Optional optHeader = context.getRequestHeader("Authorization");
        if (!optHeader.isPresent()) {
            return Optional.empty();
        }
        String header = (String)optHeader.get();
        if (!header.startsWith("Negotiate ") && !header.startsWith("Kerberos ")) {
            return Optional.empty();
        }
        byte[] base64Token = header.substring(header.indexOf(" ") + 1).getBytes(StandardCharsets.UTF_8);
        byte[] kerberosTicket = Base64.getDecoder().decode(base64Token);
        return Optional.of(new KerberosCredentials(kerberosTicket));
    }
}

