/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.kerberos.client.indirect;

import java.util.Optional;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.kerberos.credentials.extractor.KerberosExtractor;

public class IndirectKerberosClient
extends IndirectClient {
    public IndirectKerberosClient() {
    }

    public IndirectKerberosClient(Authenticator authenticator) {
        this.defaultAuthenticator(authenticator);
    }

    public IndirectKerberosClient(Authenticator authenticator, ProfileCreator profileCreator) {
        this.defaultAuthenticator(authenticator);
        this.defaultProfileCreator(profileCreator);
    }

    protected void internalInit(boolean forceReinit) {
        this.defaultRedirectionActionBuilder((webContext, sessionStore) -> Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)webContext, (String)this.computeFinalCallbackUrl(webContext))));
        this.defaultCredentialsExtractor(new KerberosExtractor());
    }

    protected Optional<Credentials> retrieveCredentials(WebContext context, SessionStore sessionStore) {
        Optional credentials;
        CommonHelper.assertNotNull((String)"credentialsExtractor", (Object)this.getCredentialsExtractor());
        CommonHelper.assertNotNull((String)"authenticator", (Object)this.getAuthenticator());
        context.setResponseHeader("WWW-Authenticate", "Negotiate");
        try {
            credentials = this.getCredentialsExtractor().extract(context, sessionStore);
            this.logger.debug("kerberos credentials : {}", (Object)credentials);
            if (!credentials.isPresent()) {
                throw HttpActionHelper.buildUnauthenticatedAction((WebContext)context);
            }
            this.getAuthenticator().validate((Credentials)credentials.get(), context, sessionStore);
        }
        catch (CredentialsException e) {
            throw HttpActionHelper.buildUnauthenticatedAction((WebContext)context);
        }
        return credentials;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"callbackUrl", this.callbackUrl, "name", this.getName(), "extractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }
}

