/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.ldap.profile.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ldaptive.AddOperation;
import org.ldaptive.AddRequest;
import org.ldaptive.AttributeModification;
import org.ldaptive.AttributeModificationType;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.Credential;
import org.ldaptive.DeleteOperation;
import org.ldaptive.DeleteRequest;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ModifyOperation;
import org.ldaptive.ModifyRequest;
import org.ldaptive.Request;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResultCode;
import org.ldaptive.auth.Authenticator;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.exception.AccountNotFoundException;
import org.pac4j.core.exception.BadCredentialsException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.definition.CommonProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.profile.service.AbstractProfileService;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.ldap.profile.LdapProfile;

public class LdapProfileService
extends AbstractProfileService<LdapProfile> {
    private Authenticator ldapAuthenticator;
    private ConnectionFactory connectionFactory;
    private String usersDn;

    public LdapProfileService() {
    }

    public LdapProfileService(Authenticator ldapAuthenticator) {
        this.ldapAuthenticator = ldapAuthenticator;
    }

    public LdapProfileService(Authenticator ldapAuthenticator, String attributes) {
        this.ldapAuthenticator = ldapAuthenticator;
        this.setAttributes(attributes);
    }

    public LdapProfileService(ConnectionFactory connectionFactory, Authenticator ldapAuthenticator, String usersDn) {
        this.connectionFactory = connectionFactory;
        this.ldapAuthenticator = ldapAuthenticator;
        this.usersDn = usersDn;
    }

    public LdapProfileService(ConnectionFactory connectionFactory, Authenticator ldapAuthenticator, String attributes, String usersDn) {
        this.connectionFactory = connectionFactory;
        this.ldapAuthenticator = ldapAuthenticator;
        this.setAttributes(attributes);
        this.usersDn = usersDn;
    }

    protected void internalInit() {
        CommonHelper.assertNotNull((String)"ldapAuthenticator", (Object)this.ldapAuthenticator);
        CommonHelper.assertNotNull((String)"connectionFactory", (Object)this.connectionFactory);
        CommonHelper.assertNull((String)"passwordEncoder", (Object)this.getPasswordEncoder());
        CommonHelper.assertNotBlank((String)"usersDn", (String)this.usersDn);
        this.defaultProfileDefinition((ProfileDefinition)new CommonProfileDefinition(x -> new LdapProfile()));
        super.internalInit();
    }

    protected void insert(Map<String, Object> attributes) {
        attributes.put("objectClass", "person");
        LdapEntry ldapEntry = new LdapEntry(this.getEntryId(attributes));
        ldapEntry.addAttributes(this.getLdapAttributes(attributes));
        try (Connection connection = null;){
            connection = this.connectionFactory.getConnection();
            connection.open();
            AddOperation add = new AddOperation(connection);
            add.execute((Request)new AddRequest(ldapEntry.getDn(), ldapEntry.getAttributes()));
        }
    }

    protected String getEntryId(Map<String, Object> attributes) {
        return this.getIdAttribute() + "=" + attributes.get(this.getIdAttribute()) + "," + this.usersDn;
    }

    protected List<LdapAttribute> getLdapAttributes(Map<String, Object> attributes) {
        ArrayList<LdapAttribute> ldapAttributes = new ArrayList<LdapAttribute>();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            LdapAttribute ldapAttribute;
            Object value = entry.getValue();
            if (value == null) continue;
            String key = entry.getKey();
            if (value instanceof String) {
                ldapAttribute = new LdapAttribute(key, new String[]{(String)value});
            } else if (value instanceof List) {
                List list = (List)value;
                ldapAttribute = new LdapAttribute(key, list.toArray(new String[list.size()]));
            } else {
                ldapAttribute = new LdapAttribute(key, new String[]{value.toString()});
            }
            ldapAttributes.add(ldapAttribute);
        }
        return ldapAttributes;
    }

    protected void update(Map<String, Object> attributes) {
        try (Connection connection = null;){
            connection = this.connectionFactory.getConnection();
            connection.open();
            ModifyOperation modify = new ModifyOperation(connection);
            ModifyRequest modifyRequest = new ModifyRequest(this.getEntryId(attributes), new AttributeModification[0]);
            ArrayList<AttributeModification> modifications = new ArrayList<AttributeModification>();
            for (LdapAttribute attribute : this.getLdapAttributes(attributes)) {
                modifications.add(new AttributeModification(AttributeModificationType.REPLACE, attribute));
            }
            modifyRequest.setAttributeModifications(modifications.toArray(new AttributeModification[modifications.size()]));
            modify.execute((Request)modifyRequest);
        }
    }

    protected void deleteById(String id) {
        try (Connection connection = null;){
            connection = this.connectionFactory.getConnection();
            connection.open();
            DeleteOperation delete = new DeleteOperation(connection);
            delete.execute((Request)new DeleteRequest(this.getIdAttribute() + "=" + id + "," + this.usersDn));
        }
    }

    protected List<Map<String, Object>> read(List<String> names, String key, String value) {
        ArrayList<Map<String, Object>> listAttributes = new ArrayList<Map<String, Object>>();
        try (Connection connection = null;){
            connection = this.connectionFactory.getConnection();
            connection.open();
            SearchOperation search = new SearchOperation(connection);
            SearchResult result = (SearchResult)search.execute((Request)new SearchRequest(this.usersDn, key + "=" + value, names.toArray(new String[names.size()]))).getResult();
            for (LdapEntry entry : result.getEntries()) {
                listAttributes.add(this.getAttributesFromEntry(entry));
            }
        }
        return listAttributes;
    }

    protected Map<String, Object> getAttributesFromEntry(LdapEntry entry) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (LdapAttribute attribute : entry.getAttributes()) {
            String name = attribute.getName();
            if (attribute.size() > 1) {
                attributes.put(name, attribute.getStringValues());
                continue;
            }
            attributes.put(name, attribute.getStringValue());
        }
        return attributes;
    }

    public void validate(UsernamePasswordCredentials credentials, WebContext context) {
        AuthenticationResponse response;
        this.init();
        String username = credentials.getUsername();
        CommonHelper.assertNotBlank((String)"username", (String)username);
        try {
            this.logger.debug("Attempting LDAP authentication for: {}", (Object)credentials);
            List attributesToRead = this.defineAttributesToRead();
            AuthenticationRequest request = new AuthenticationRequest(username, new Credential(credentials.getPassword()), attributesToRead.toArray(new String[attributesToRead.size()]));
            response = this.ldapAuthenticator.authenticate(request);
        }
        catch (LdapException e) {
            throw new TechnicalException("Unexpected LDAP error", (Throwable)e);
        }
        this.logger.debug("LDAP response: {}", (Object)response);
        if (((Boolean)response.getResult()).booleanValue()) {
            LdapEntry entry = response.getLdapEntry();
            ArrayList<Map<String, Object>> listAttributes = new ArrayList<Map<String, Object>>();
            listAttributes.add(this.getAttributesFromEntry(entry));
            LdapProfile profile = (LdapProfile)this.convertAttributesToProfile(listAttributes, username);
            credentials.setUserProfile((CommonProfile)profile);
            return;
        }
        if (AuthenticationResultCode.DN_RESOLUTION_FAILURE == response.getAuthenticationResultCode()) {
            throw new AccountNotFoundException(username + " not found");
        }
        throw new BadCredentialsException("Invalid credentials for: " + username);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getUsersDn() {
        return this.usersDn;
    }

    public void setUsersDn(String usersDn) {
        this.usersDn = usersDn;
    }

    public Authenticator getLdapAuthenticator() {
        return this.ldapAuthenticator;
    }

    public void setLdapAuthenticator(Authenticator ldapAuthenticator) {
        this.ldapAuthenticator = ldapAuthenticator;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"connectionFactory", this.connectionFactory, "ldapAuthenticator", this.ldapAuthenticator, "usersDn", this.usersDn, "idAttribute", this.getIdAttribute(), "attributes", this.getAttributes(), "profileDefinition", this.getProfileDefinition()});
    }
}

