/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.builder.api;

import org.apache.commons.lang3.RandomStringUtils;
import org.scribe.builder.api.DefaultApi20;
import org.scribe.extractors.AccessTokenExtractor;
import org.scribe.extractors.PayPalJsonExtractor;
import org.scribe.model.OAuthConfig;
import org.scribe.utils.OAuthEncoder;
import org.scribe.utils.Preconditions;

public class PayPalApi20
extends DefaultApi20 {
    private static final String AUTHORIZATION_URL = "https://www.paypal.com/webapps/auth/protocol/openidconnect/v1/authorize?client_id=%s&redirect_uri=%s&scope=%s&response_type=code&nonce=%s";

    public String getAuthorizationUrl(OAuthConfig config) {
        Preconditions.checkValidUrl((String)config.getCallback(), (String)"Must provide a valid url as callback. PayPal does not support OOB");
        String nonce = System.currentTimeMillis() + RandomStringUtils.random((int)10, (boolean)true, (boolean)true);
        return String.format(AUTHORIZATION_URL, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()), OAuthEncoder.encode((String)config.getScope()), nonce);
    }

    public String getAccessTokenEndpoint() {
        return "https://api.paypal.com/v1/identity/openidconnect/tokenservice";
    }

    public AccessTokenExtractor getAccessTokenExtractor() {
        return new PayPalJsonExtractor();
    }
}

