/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.extractors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scribe.exceptions.OAuthException;
import org.scribe.extractors.AccessTokenExtractor;
import org.scribe.model.Token;
import org.scribe.tokens.OrcidToken;
import org.scribe.utils.Preconditions;

public class OrcidJsonExtractor
implements AccessTokenExtractor {
    private final Pattern accessTokenPattern = Pattern.compile("\"access_token\"\\s*:\\s*\"(\\S*?)\"");
    private final Pattern orcidTokenPattern = Pattern.compile("\"orcid\"\\s*:\\s*\"(\\S*?)\"");

    public Token extract(String response) {
        Preconditions.checkEmptyString((String)response, (String)"Cannot extract a token from a null or empty String");
        Matcher matcher = this.accessTokenPattern.matcher(response);
        if (matcher.find() && matcher.groupCount() > 0) {
            String accessToken = matcher.group(1);
            matcher = this.orcidTokenPattern.matcher(response);
            if (matcher.find() && matcher.groupCount() > 0) {
                return new OrcidToken(accessToken, "", matcher.group(1), response);
            }
            throw new OAuthException("Cannot extract orcid. Response was: " + response);
        }
        throw new OAuthException("Cannot extract an access token. Response was: " + response);
    }
}

