/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.BaseOAuth20Client;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.google2.Google2Profile;
import org.scribe.builder.api.GoogleApi20;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.oauth.StateOAuth20ServiceImpl;

public class Google2Client
extends BaseOAuth20Client<Google2Profile> {
    protected final String PROFILE_SCOPE = "profile";
    protected final String EMAIL_SCOPE = "email";
    protected Google2Scope scope = Google2Scope.EMAIL_AND_PROFILE;
    protected String scopeValue;

    public Google2Client() {
    }

    public Google2Client(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    protected Google2Client newClient() {
        Google2Client newClient = new Google2Client();
        newClient.setScope(this.scope);
        return newClient;
    }

    @Override
    protected void internalInit() {
        super.internalInit();
        CommonHelper.assertNotNull((String)"scope", (Object)((Object)this.scope));
        this.scopeValue = this.scope == Google2Scope.EMAIL ? this.EMAIL_SCOPE : (this.scope == Google2Scope.PROFILE ? this.PROFILE_SCOPE : this.PROFILE_SCOPE + " " + this.EMAIL_SCOPE);
        this.service = new StateOAuth20ServiceImpl(new GoogleApi20(), new OAuthConfig(this.key, this.secret, this.callbackUrl, SignatureType.Header, this.scopeValue, null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort, false, true);
    }

    @Override
    protected String getProfileUrl(Token accessToken) {
        return "https://www.googleapis.com/plus/v1/people/me";
    }

    @Override
    protected Google2Profile extractUserProfile(String body) {
        Google2Profile profile = new Google2Profile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(JsonHelper.get(json, "id"));
            for (String attribute : OAuthAttributesDefinitions.google2Definition.getPrincipalAttributes()) {
                profile.addAttribute(attribute, JsonHelper.get(json, attribute));
            }
        }
        return profile;
    }

    public Google2Scope getScope() {
        return this.scope;
    }

    public void setScope(Google2Scope scope) {
        this.scope = scope;
    }

    @Override
    protected boolean requiresStateParameter() {
        return true;
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        String error = context.getRequestParameter("error");
        return "access_denied".equals(error);
    }

    public static enum Google2Scope {
        EMAIL,
        PROFILE,
        EMAIL_AND_PROFILE;

    }
}

