/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.builder.api;

import org.scribe.builder.api.StateApi20;
import org.scribe.extractors.AccessTokenExtractor;
import org.scribe.extractors.Google2JsonExtractor;
import org.scribe.model.OAuthConfig;
import org.scribe.model.Verb;
import org.scribe.utils.OAuthEncoder;
import org.scribe.utils.Preconditions;

public class LinkedInApi20
extends StateApi20 {
    private static final String AUTHORIZATION_URL = "https://www.linkedin.com/uas/oauth2/authorization?response_type=code&client_id=%s&scope=%s&state=%s&redirect_uri=%s";

    public String getAccessTokenEndpoint() {
        return "https://www.linkedin.com/uas/oauth2/accessToken?grant_type=authorization_code";
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    @Override
    public String getAuthorizationUrl(OAuthConfig config, String state) {
        Preconditions.checkValidUrl((String)config.getCallback(), (String)"Must provide a valid url as callback. LinkedIn does not support OOB");
        return String.format(AUTHORIZATION_URL, config.getApiKey(), OAuthEncoder.encode((String)config.getScope()), OAuthEncoder.encode((String)state), OAuthEncoder.encode((String)config.getCallback()));
    }

    public AccessTokenExtractor getAccessTokenExtractor() {
        return new Google2JsonExtractor();
    }
}

