/*
  Copyright 2012 - 2015 pac4j organization

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */
package org.pac4j.oauth.profile.converter;

import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.oauth.profile.XmlList;

/**
 * This class converts a XML text into a list of objects.
 * 
 * @author Jerome Leleu
 * @since 1.4.1
 */
@SuppressWarnings({
    "rawtypes", "unchecked"
})
public final class XmlListConverter implements AttributeConverter<XmlList> {
    
    private final Class<? extends Object> clazz;
    
    public XmlListConverter(final Class<? extends Object> clazz) {
        this.clazz = clazz;
    }
    
    public XmlList convert(final Object attribute) {
        if (attribute != null && attribute instanceof String) {
            return new XmlList((String) attribute, this.clazz);
        }
        return null;
    }
}
