/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import org.apache.commons.lang3.RandomStringUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.BaseOAuth20Client;
import org.pac4j.oauth.client.exception.OAuthCredentialsException;
import org.pac4j.oauth.credentials.OAuthCredentials;
import org.pac4j.oauth.profile.OAuth20Profile;
import org.scribe.oauth.StateOAuth20Service;

public abstract class BaseOAuth20StateClient<U extends OAuth20Profile>
extends BaseOAuth20Client {
    private static final String STATE_PARAMETER = "#oauth20StateParameter";
    private String stateData;

    protected String getState() {
        String stateParameter = CommonHelper.isNotBlank((String)this.stateData) ? this.stateData : RandomStringUtils.randomAlphanumeric((int)10);
        return stateParameter;
    }

    public void setState(String stateParameter) {
        this.stateData = stateParameter;
    }

    protected String getAuthorizationUrl(String state) {
        String authorizationUrl = ((StateOAuth20Service)this.service).getAuthorizationUrl(state);
        logger.debug("authorizationUrl : {}", (Object)authorizationUrl);
        return authorizationUrl;
    }

    @Override
    protected String retrieveAuthorizationUrl(WebContext context) {
        String state = this.getState();
        context.setSessionAttribute(this.getName() + STATE_PARAMETER, (Object)state);
        return this.getAuthorizationUrl(state);
    }

    @Override
    protected OAuthCredentials getOAuthCredentials(WebContext context) {
        String stateParameter = context.getRequestParameter("state");
        if (CommonHelper.isNotBlank((String)stateParameter)) {
            String sessionState = (String)context.getSessionAttribute(this.getName() + STATE_PARAMETER);
            context.setSessionAttribute(this.getName() + STATE_PARAMETER, null);
            logger.debug("sessionState : {} / stateParameter : {}", (Object)sessionState, (Object)stateParameter);
            if (!stateParameter.equals(sessionState)) {
                String message = "State parameter mismatch : session expired or possible threat of cross-site request forgery";
                throw new OAuthCredentialsException("State parameter mismatch : session expired or possible threat of cross-site request forgery");
            }
        } else {
            String message = "Missing state parameter : session expired or possible threat of cross-site request forgery";
            throw new OAuthCredentialsException("Missing state parameter : session expired or possible threat of cross-site request forgery");
        }
        return super.getOAuthCredentials(context);
    }
}

