/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.fasterxml.jackson.databind.JsonNode;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.BaseOAuth20StateClient;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.facebook.FacebookProfile;
import org.scribe.builder.api.ExtendedFacebookApi;
import org.scribe.builder.api.StateApi20;
import org.scribe.model.OAuthConfig;
import org.scribe.model.ProxyOAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.oauth.StateOAuth20ServiceImpl;

public class FacebookClient
extends BaseOAuth20StateClient<FacebookProfile> {
    private static final String EXCHANGE_TOKEN_URL = "https://graph.facebook.com/v2.4/oauth/access_token?grant_type=fb_exchange_token";
    private static final String EXCHANGE_TOKEN_PARAMETER = "fb_exchange_token";
    private static final String APPSECRET_PARAMETER = "appsecret_proof";
    public static final String DEFAULT_FIELDS = "id,name,first_name,middle_name,last_name,gender,locale,languages,link,third_party_id,timezone,updated_time,verified,bio,birthday,education,email,hometown,interested_in,location,political,favorite_athletes,favorite_teams,quotes,relationship_status,religion,significant_other,website,work";
    protected String fields = "id,name,first_name,middle_name,last_name,gender,locale,languages,link,third_party_id,timezone,updated_time,verified,bio,birthday,education,email,hometown,interested_in,location,political,favorite_athletes,favorite_teams,quotes,relationship_status,religion,significant_other,website,work";
    protected static final String BASE_URL = "https://graph.facebook.com/v2.4/me";
    public static final String DEFAULT_SCOPE = "user_likes,user_about_me,user_birthday,user_education_history,email,user_hometown,user_relationship_details,user_location,user_religion_politics,user_relationships,user_website,user_work_history";
    protected String scope = "user_likes,user_about_me,user_birthday,user_education_history,email,user_hometown,user_relationship_details,user_location,user_religion_politics,user_relationships,user_website,user_work_history";
    public static final int DEFAULT_LIMIT = 0;
    protected int limit = 0;
    protected boolean requiresExtendedToken = false;
    protected StateApi20 api20;
    protected boolean useAppsecretProof = false;

    public FacebookClient() {
    }

    public FacebookClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    protected FacebookClient newClient() {
        FacebookClient newClient = new FacebookClient();
        newClient.setScope(this.scope);
        newClient.setFields(this.fields);
        newClient.setLimit(this.limit);
        return newClient;
    }

    @Override
    protected void internalInit(WebContext context) {
        super.internalInit(context);
        CommonHelper.assertNotBlank((String)"fields", (String)this.fields);
        this.api20 = new ExtendedFacebookApi();
        this.service = StringUtils.isNotBlank((CharSequence)this.scope) ? new StateOAuth20ServiceImpl(this.api20, new OAuthConfig(this.key, this.secret, this.computeFinalCallbackUrl(context), SignatureType.Header, this.scope, null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort) : new StateOAuth20ServiceImpl(this.api20, new OAuthConfig(this.key, this.secret, this.computeFinalCallbackUrl(context), SignatureType.Header, null, null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
    }

    @Override
    protected String getProfileUrl(Token accessToken) {
        String url = "https://graph.facebook.com/v2.4/me?fields=" + this.fields;
        if (this.limit > 0) {
            url = url + "&limit=" + this.limit;
        }
        if (this.useAppsecretProof) {
            url = this.computeAppSecretProof(url, accessToken);
        }
        return url;
    }

    @Override
    protected FacebookProfile retrieveUserProfileFromToken(Token accessToken) {
        String body = this.sendRequestForData(accessToken, this.getProfileUrl(accessToken));
        if (body == null) {
            throw new HttpCommunicationException("Not data found for accessToken : " + accessToken);
        }
        FacebookProfile profile = this.extractUserProfile(body);
        this.addAccessTokenToProfile(profile, accessToken);
        if (profile != null && this.requiresExtendedToken) {
            String url = CommonHelper.addParameter((String)EXCHANGE_TOKEN_URL, (String)"client_id", (String)this.key);
            url = CommonHelper.addParameter((String)url, (String)"client_secret", (String)this.secret);
            url = this.addExchangeToken(url, accessToken);
            ProxyOAuthRequest request = this.createProxyRequest(url);
            long t0 = System.currentTimeMillis();
            Response response = request.send();
            int code = response.getCode();
            body = response.getBody();
            long t1 = System.currentTimeMillis();
            logger.debug("Request took : " + (t1 - t0) + " ms for : " + url);
            logger.debug("response code : {} / response body : {}", (Object)code, (Object)body);
            if (code == 200) {
                logger.debug("Retrieve extended token from : {}", (Object)body);
                Token extendedAccessToken = this.api20.getAccessTokenExtractor().extract(body);
                logger.debug("Extended token : {}", (Object)extendedAccessToken);
                this.addAccessTokenToProfile(profile, extendedAccessToken);
            } else {
                logger.error("Cannot get extended token : {} / {}", (Object)code, (Object)body);
            }
        }
        return profile;
    }

    @Override
    protected FacebookProfile extractUserProfile(String body) {
        FacebookProfile profile = new FacebookProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(JsonHelper.get(json, "id"));
            for (String attribute : OAuthAttributesDefinitions.facebookDefinition.getAllAttributes()) {
                profile.addAttribute(attribute, JsonHelper.get(json, attribute));
            }
            this.extractData(profile, json, "friends");
            this.extractData(profile, json, "movies");
            this.extractData(profile, json, "music");
            this.extractData(profile, json, "books");
            this.extractData(profile, json, "likes");
            this.extractData(profile, json, "albums");
            this.extractData(profile, json, "events");
            this.extractData(profile, json, "groups");
            this.extractData(profile, json, "music.listens");
            this.extractData(profile, json, "picture");
        }
        return profile;
    }

    protected void extractData(FacebookProfile profile, JsonNode json, String name) {
        JsonNode data = (JsonNode)JsonHelper.get(json, name);
        if (data != null) {
            profile.addAttribute(name, JsonHelper.get(data, "data"));
        }
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        String error = context.getRequestParameter("error");
        String errorReason = context.getRequestParameter("error_reason");
        return "access_denied".equals(error) && "user_denied".equals(errorReason);
    }

    public void setUseAppSecretProof(boolean useSecret) {
        this.useAppsecretProof = useSecret;
    }

    public boolean getUseAppSecretProof() {
        return this.useAppsecretProof;
    }

    protected String computeAppSecretProof(String url, Token token) {
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(this.secret.getBytes("UTF-8"), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            String proof = Hex.encodeHexString((byte[])sha256_HMAC.doFinal(token.getToken().getBytes("UTF-8")));
            url = CommonHelper.addParameter((String)url, (String)APPSECRET_PARAMETER, (String)proof);
            return url;
        }
        catch (Exception e) {
            throw new TechnicalException("Unable to compute appsecret_proof", (Throwable)e);
        }
    }

    protected String addExchangeToken(String url, Token accessToken) {
        if (this.useAppsecretProof) {
            url = this.computeAppSecretProof(url, accessToken);
        }
        return CommonHelper.addParameter((String)url, (String)EXCHANGE_TOKEN_PARAMETER, (String)accessToken.getToken());
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean isRequiresExtendedToken() {
        return this.requiresExtendedToken;
    }

    public void setRequiresExtendedToken(boolean requiresExtendedToken) {
        this.requiresExtendedToken = requiresExtendedToken;
    }
}

