/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.BaseOAuth20Client;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.paypal.PayPalProfile;
import org.scribe.builder.api.PayPalApi20;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.oauth.PayPalOAuth20ServiceImpl;

public class PayPalClient
extends BaseOAuth20Client<PayPalProfile> {
    public static final String DEFAULT_SCOPE = "openid profile email address";
    protected String scope = "openid profile email address";

    public PayPalClient() {
        this.setTokenAsHeader(true);
    }

    public PayPalClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
        this.setTokenAsHeader(true);
    }

    protected PayPalClient newClient() {
        PayPalClient newClient = new PayPalClient();
        newClient.setScope(this.scope);
        return newClient;
    }

    @Override
    protected void internalInit(WebContext context) {
        super.internalInit(context);
        CommonHelper.assertNotBlank((String)"scope", (String)this.scope);
        this.service = new PayPalOAuth20ServiceImpl(new PayPalApi20(), new OAuthConfig(this.key, this.secret, this.computeFinalCallbackUrl(context), SignatureType.Header, this.scope, null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
    }

    @Override
    protected String getProfileUrl(Token accessToken) {
        return "https://api.paypal.com/v1/identity/openidconnect/userinfo?schema=openid";
    }

    @Override
    protected PayPalProfile extractUserProfile(String body) {
        PayPalProfile profile = new PayPalProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            String userId = (String)JsonHelper.get(json, "user_id");
            profile.setId(StringUtils.substringAfter((String)userId, (String)"/user/"));
            for (String attribute : OAuthAttributesDefinitions.payPalDefinition.getAllAttributes()) {
                profile.addAttribute(attribute, JsonHelper.get(json, attribute));
            }
        }
        return profile;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        return false;
    }
}

