/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.BaseOAuth20StateClient;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.XmlHelper;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2Profile;
import org.scribe.builder.api.LinkedInApi20;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.oauth.LinkedInOAuth20ServiceImpl;

public class LinkedIn2Client
extends BaseOAuth20StateClient<LinkedIn2Profile> {
    public static final String DEFAULT_SCOPE = "r_fullprofile";
    protected String scope = "r_fullprofile";
    protected String fields = "id,first-name,last-name,maiden-name,formatted-name,location,email-address,headline,industry,num-connections,summary,specialties,positions,picture-url,site-standard-profile-request,public-profile-url";

    public LinkedIn2Client() {
    }

    public LinkedIn2Client(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    protected LinkedIn2Client newClient() {
        LinkedIn2Client newClient = new LinkedIn2Client();
        newClient.setScope(this.scope);
        newClient.setFields(this.fields);
        return newClient;
    }

    @Override
    protected void internalInit(WebContext context) {
        super.internalInit(context);
        CommonHelper.assertNotBlank((String)"scope", (String)this.scope);
        CommonHelper.assertNotBlank((String)"fields", (String)this.fields);
        LinkedInApi20 api20 = new LinkedInApi20();
        this.service = new LinkedInOAuth20ServiceImpl(api20, new OAuthConfig(this.key, this.secret, this.computeFinalCallbackUrl(context), SignatureType.Header, this.scope, null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        String error = context.getRequestParameter("error");
        String errorDescription = context.getRequestParameter("error_description");
        return "access_denied".equals(error) && ("the+user+denied+your+request".equals(errorDescription) || "the user denied your request".equals(errorDescription));
    }

    @Override
    protected String getProfileUrl(Token accessToken) {
        return "https://api.linkedin.com/v1/people/~:(" + this.fields + ")";
    }

    @Override
    protected LinkedIn2Profile extractUserProfile(String body) {
        LinkedIn2Profile profile = new LinkedIn2Profile();
        profile.setId(XmlHelper.get(body, "id"));
        for (String attribute : OAuthAttributesDefinitions.linkedin2Definition.getPrincipalAttributes()) {
            profile.addAttribute(attribute, XmlHelper.get(body, attribute));
        }
        String url = XmlHelper.get(XmlHelper.get(body, "site-standard-profile-request"), "url");
        profile.addAttribute("site-standard-profile-request", url);
        return profile;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }
}

