/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.pac4j.core.context.WebContext;
import org.pac4j.oauth.client.BaseOAuth20Client;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.strava.StravaProfile;
import org.scribe.builder.api.StravaApi;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.oauth.ProxyOAuth20ServiceImpl;

public class StravaClient
extends BaseOAuth20Client<StravaProfile> {
    protected String scope = null;
    private String approvalPrompt = "auto";

    public StravaClient() {
    }

    public StravaClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    public String getApprovalPrompt() {
        return this.approvalPrompt;
    }

    public void setApprovalPrompt(String approvalPrompt) {
        this.approvalPrompt = approvalPrompt;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    protected StravaClient newClient() {
        StravaClient client = new StravaClient();
        client.setScope(this.scope);
        return client;
    }

    @Override
    protected void internalInit(WebContext context) {
        super.internalInit(context);
        this.service = new ProxyOAuth20ServiceImpl(new StravaApi(this.approvalPrompt), new OAuthConfig(this.key, this.secret, this.computeFinalCallbackUrl(context), SignatureType.Header, this.scope, null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort, false, false);
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        return false;
    }

    @Override
    protected String getProfileUrl(Token accessToken) {
        return "https://www.strava.com/api/v3/athlete";
    }

    @Override
    protected StravaProfile extractUserProfile(String body) {
        StravaProfile profile = new StravaProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(JsonHelper.get(json, "id"));
            for (String attribute : OAuthAttributesDefinitions.stravaDefinition.getAllAttributes()) {
                profile.addAttribute(attribute, JsonHelper.get(json, attribute));
            }
        }
        return profile;
    }

    @Override
    protected boolean isDirectRedirection() {
        return false;
    }
}

