/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.pac4j.oauth.profile.XmlHelper;
import org.pac4j.oauth.profile.XmlMatch;
import org.pac4j.oauth.profile.XmlObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlList<T>
extends XmlObject
implements List<T> {
    private static final long serialVersionUID = -3439014616371376590L;
    private static final Logger logger = LoggerFactory.getLogger(XmlList.class);
    private List<T> list = new ArrayList<T>();
    private Class<T> clazz;

    public XmlList() {
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    public XmlList(String xml, Class<T> clazz) {
        this.clazz = clazz;
        this.buildFrom(xml);
    }

    @Override
    protected void buildFromXml(String xml) {
        int end;
        int start;
        if (xml != null && (start = xml.indexOf("<")) >= 0 && (end = xml.indexOf(">", start)) > start) {
            String tag = xml.substring(start + 1, end);
            int pos = 0;
            XmlMatch match = XmlHelper.get(xml, tag, pos);
            String element = match.getText();
            pos = match.getPos() + 1;
            while (element != null) {
                this.buildSingleNode(element);
                match = XmlHelper.get(xml, tag, pos);
                if (match == null) break;
                element = match.getText();
                pos = match.getPos() + 1;
            }
        }
    }

    private void buildSingleNode(String xml) {
        if (this.clazz == String.class) {
            this.list.add(xml);
        } else if (XmlObject.class.isAssignableFrom(this.clazz)) {
            try {
                Constructor<T> constructor = this.clazz.getDeclaredConstructor(new Class[0]);
                T object = constructor.newInstance(new Object[0]);
                ((XmlObject)((Object)object)).buildFrom(xml);
                this.list.add(object);
            }
            catch (Exception e) {
                logger.error("Cannot build object", (Throwable)e);
            }
        }
    }

    @Override
    public boolean add(T e) {
        return this.list.add(e);
    }

    @Override
    public void add(int index, T element) {
        this.list.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public T remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public T set(int index, T element) {
        return this.list.set(index, element);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }
}

