/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.builder.api;

import org.scribe.builder.api.DefaultApi20;
import org.scribe.extractors.AccessTokenExtractor;
import org.scribe.extractors.JsonTokenExtractor;
import org.scribe.extractors.TokenExtractor20Impl;
import org.scribe.model.OAuthConfig;
import org.scribe.model.Verb;
import org.scribe.utils.OAuthEncoder;

public class CasOAuthWrapperApi20
extends DefaultApi20 {
    private final String casServerUrl;
    private final boolean springSecurityCompliant;

    public CasOAuthWrapperApi20(String casServerUrl, boolean springSecurityCompliant) {
        this.casServerUrl = casServerUrl;
        this.springSecurityCompliant = springSecurityCompliant;
    }

    public AccessTokenExtractor getAccessTokenExtractor() {
        if (this.springSecurityCompliant) {
            return new JsonTokenExtractor();
        }
        return new TokenExtractor20Impl();
    }

    public String getAccessTokenEndpoint() {
        return this.casServerUrl + "/accessToken?";
    }

    public String getAuthorizationUrl(OAuthConfig config) {
        return String.format(this.casServerUrl + "/authorize?" + "response_type=code&client_id=%s&redirect_uri=%s", config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()));
    }

    public Verb getAccessTokenVerb() {
        if (this.springSecurityCompliant) {
            return Verb.PUT;
        }
        return Verb.POST;
    }
}

