/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.apis.TwitterApi;
import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.oauth.OAuth10aService;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.OAuth10Client;
import org.pac4j.oauth.profile.twitter.TwitterProfile;
import org.pac4j.oauth.profile.twitter.TwitterProfileDefinition;

public class TwitterClient
extends OAuth10Client<TwitterProfile> {
    private boolean alwaysConfirmAuthorization = false;

    public TwitterClient() {
    }

    public TwitterClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void clientInit(WebContext context) {
        this.configuration.setApi(this.getApi());
        this.configuration.setProfileDefinition(new TwitterProfileDefinition());
        this.configuration.setHasBeenCancelledFactory(ctx -> {
            String denied = ctx.getRequestParameter("denied");
            if (CommonHelper.isNotBlank((String)denied)) {
                return true;
            }
            return false;
        });
        this.setConfiguration(this.configuration);
        this.defaultLogoutActionBuilder((ctx, profile, targetUrl) -> RedirectAction.redirect((String)"https://twitter.com/logout"));
        super.clientInit(context);
    }

    protected BaseApi<OAuth10aService> getApi() {
        Object api = !this.alwaysConfirmAuthorization ? TwitterApi.Authenticate.instance() : TwitterApi.instance();
        return api;
    }

    public boolean isAlwaysConfirmAuthorization() {
        return this.alwaysConfirmAuthorization;
    }

    public void setAlwaysConfirmAuthorization(boolean alwaysConfirmAuthorization) {
        this.alwaysConfirmAuthorization = alwaysConfirmAuthorization;
    }
}

