/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.credentials.authenticator;

import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.model.OAuth1Token;
import com.github.scribejava.core.oauth.OAuth10aService;
import java.io.IOException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.pac4j.oauth.credentials.OAuth10Credentials;
import org.pac4j.oauth.credentials.OAuthCredentials;
import org.pac4j.oauth.credentials.authenticator.OAuthAuthenticator;
import org.pac4j.oauth.exception.OAuthCredentialsException;

public class OAuth10Authenticator
extends OAuthAuthenticator<OAuth10Credentials, OAuth10Configuration> {
    public OAuth10Authenticator(OAuth10Configuration configuration) {
        super(configuration);
    }

    @Override
    protected void retrieveAccessToken(OAuthCredentials credentials) throws HttpAction, OAuthCredentialsException {
        OAuth1AccessToken accessToken;
        OAuth10Credentials oAuth10Credentials = (OAuth10Credentials)credentials;
        OAuth1RequestToken tokenRequest = oAuth10Credentials.getRequestToken();
        String token = oAuth10Credentials.getToken();
        String verifier = oAuth10Credentials.getVerifier();
        this.logger.debug("tokenRequest: {}", (Object)tokenRequest);
        this.logger.debug("token: {}", (Object)token);
        this.logger.debug("verifier: {}", (Object)verifier);
        if (tokenRequest == null) {
            String message = "Token request expired";
            throw new OAuthCredentialsException("Token request expired");
        }
        String savedToken = tokenRequest.getToken();
        this.logger.debug("savedToken: {}", (Object)savedToken);
        if (savedToken == null || !savedToken.equals(token)) {
            String message = "Token received: " + token + " is different from saved token: " + savedToken;
            throw new OAuthCredentialsException(message);
        }
        try {
            accessToken = ((OAuth10aService)((OAuth10Configuration)this.configuration).getService()).getAccessToken(tokenRequest, verifier);
        }
        catch (IOException ex) {
            throw new HttpCommunicationException("Error getting token:" + ex.getMessage());
        }
        this.logger.debug("accessToken: {}", (Object)accessToken);
        oAuth10Credentials.setAccessToken((OAuth1Token)accessToken);
    }
}

