/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.credentials.authenticator;

import com.github.scribejava.core.exceptions.OAuthException;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.credentials.OAuthCredentials;
import org.pac4j.oauth.exception.OAuthCredentialsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class OAuthAuthenticator<C extends OAuthCredentials, O extends OAuthConfiguration>
extends InitializableWebObject
implements Authenticator<C> {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final O configuration;

    protected OAuthAuthenticator(O configuration) {
        this.configuration = configuration;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"configuration", this.configuration);
        this.configuration.init(context);
    }

    public void validate(C credentials, WebContext context) throws HttpAction, CredentialsException {
        this.init(context);
        try {
            this.retrieveAccessToken((OAuthCredentials)((Object)credentials));
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected abstract void retrieveAccessToken(OAuthCredentials var1) throws HttpAction, OAuthCredentialsException;

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"configuration", this.configuration});
    }
}

