/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.facebook;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.OAuth2AccessToken;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.core.profile.converter.DateConverter;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.converter.JsonConverter;
import org.pac4j.oauth.profile.definition.OAuth20ProfileDefinition;
import org.pac4j.oauth.profile.facebook.FacebookConfiguration;
import org.pac4j.oauth.profile.facebook.FacebookEducation;
import org.pac4j.oauth.profile.facebook.FacebookEvent;
import org.pac4j.oauth.profile.facebook.FacebookGroup;
import org.pac4j.oauth.profile.facebook.FacebookInfo;
import org.pac4j.oauth.profile.facebook.FacebookMusicListen;
import org.pac4j.oauth.profile.facebook.FacebookObject;
import org.pac4j.oauth.profile.facebook.FacebookPhoto;
import org.pac4j.oauth.profile.facebook.FacebookPicture;
import org.pac4j.oauth.profile.facebook.FacebookProfile;
import org.pac4j.oauth.profile.facebook.FacebookWork;
import org.pac4j.oauth.profile.facebook.converter.FacebookRelationshipStatusConverter;

public class FacebookProfileDefinition
extends OAuth20ProfileDefinition<FacebookProfile, FacebookConfiguration> {
    public static final String NAME = "name";
    public static final String MIDDLE_NAME = "middle_name";
    public static final String LAST_NAME = "last_name";
    public static final String LANGUAGES = "languages";
    public static final String LINK = "link";
    public static final String THIRD_PARTY_ID = "third_party_id";
    public static final String TIMEZONE = "timezone";
    public static final String UPDATED_TIME = "updated_time";
    public static final String VERIFIED = "verified";
    public static final String ABOUT = "about";
    public static final String BIRTHDAY = "birthday";
    public static final String EDUCATION = "education";
    public static final String HOMETOWN = "hometown";
    public static final String INTERESTED_IN = "interested_in";
    public static final String POLITICAL = "political";
    public static final String FAVORITE_ATHLETES = "favorite_athletes";
    public static final String FAVORITE_TEAMS = "favorite_teams";
    public static final String QUOTES = "quotes";
    public static final String RELATIONSHIP_STATUS = "relationship_status";
    public static final String RELIGION = "religion";
    public static final String SIGNIFICANT_OTHER = "significant_other";
    public static final String WEBSITE = "website";
    public static final String WORK = "work";
    public static final String FRIENDS = "friends";
    public static final String MOVIES = "movies";
    public static final String MUSIC = "music";
    public static final String BOOKS = "books";
    public static final String LIKES = "likes";
    public static final String ALBUMS = "albums";
    public static final String EVENTS = "events";
    public static final String GROUPS = "groups";
    public static final String MUSIC_LISTENS = "music.listens";
    public static final String PICTURE = "picture";
    public static final int DEFAULT_LIMIT = 0;
    protected static final String BASE_URL = "https://graph.facebook.com/v2.8/me";
    protected static final String APPSECRET_PARAMETER = "appsecret_proof";

    public FacebookProfileDefinition() {
        super(x -> new FacebookProfile());
        Arrays.stream(new String[]{NAME, MIDDLE_NAME, LAST_NAME, THIRD_PARTY_ID, ABOUT, POLITICAL, QUOTES, RELIGION, WEBSITE}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.STRING));
        this.primary(TIMEZONE, (AttributeConverter)Converters.INTEGER);
        this.primary(VERIFIED, (AttributeConverter)Converters.BOOLEAN);
        this.primary(LINK, (AttributeConverter)Converters.URL);
        JsonConverter<FacebookObject> objectConverter = new JsonConverter<FacebookObject>(FacebookObject.class);
        JsonConverter<List<FacebookObject>> multiObjectConverter = new JsonConverter<List<FacebookObject>>(List.class, new TypeReference<List<FacebookObject>>(){});
        JsonConverter<List<FacebookInfo>> multiInfoConverter = new JsonConverter<List<FacebookInfo>>(List.class, new TypeReference<List<FacebookInfo>>(){});
        this.primary(UPDATED_TIME, (AttributeConverter)Converters.DATE_TZ_GENERAL);
        this.primary(BIRTHDAY, (AttributeConverter)new DateConverter("MM/dd/yyyy"));
        this.primary(RELATIONSHIP_STATUS, new FacebookRelationshipStatusConverter());
        this.primary(LANGUAGES, multiObjectConverter);
        this.primary(EDUCATION, new JsonConverter<List<FacebookEducation>>(List.class, new TypeReference<List<FacebookEducation>>(){}));
        this.primary(HOMETOWN, objectConverter);
        this.primary(INTERESTED_IN, new JsonConverter<List<String>>(List.class, new TypeReference<List<String>>(){}));
        this.primary("location", objectConverter);
        this.primary(FAVORITE_ATHLETES, multiObjectConverter);
        this.primary(FAVORITE_TEAMS, multiObjectConverter);
        this.primary(SIGNIFICANT_OTHER, objectConverter);
        this.primary(WORK, new JsonConverter<List<FacebookWork>>(List.class, new TypeReference<List<FacebookWork>>(){}));
        this.secondary(FRIENDS, multiObjectConverter);
        this.secondary(MOVIES, multiInfoConverter);
        this.secondary(MUSIC, multiInfoConverter);
        this.secondary(BOOKS, multiInfoConverter);
        this.secondary(LIKES, multiInfoConverter);
        this.secondary(ALBUMS, new JsonConverter<List<FacebookPhoto>>(List.class, new TypeReference<List<FacebookPhoto>>(){}));
        this.secondary(EVENTS, new JsonConverter<List<FacebookEvent>>(List.class, new TypeReference<List<FacebookEvent>>(){}));
        this.secondary(GROUPS, new JsonConverter<List<FacebookGroup>>(List.class, new TypeReference<List<FacebookGroup>>(){}));
        this.secondary(MUSIC_LISTENS, new JsonConverter<List<FacebookMusicListen>>(List.class, new TypeReference<List<FacebookMusicListen>>(){}));
        this.secondary(PICTURE, new JsonConverter<FacebookPicture>(FacebookPicture.class));
    }

    @Override
    public String getProfileUrl(OAuth2AccessToken accessToken, FacebookConfiguration configuration) {
        String url = "https://graph.facebook.com/v2.8/me?fields=" + configuration.getFields();
        if (configuration.getLimit() > 0) {
            url = url + "&limit=" + configuration.getLimit();
        }
        if (configuration.isUseAppsecretProof()) {
            url = this.computeAppSecretProof(url, accessToken, configuration);
        }
        return url;
    }

    public String computeAppSecretProof(String url, OAuth2AccessToken token, FacebookConfiguration configuration) {
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(configuration.getSecret().getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            String proof = Hex.encodeHexString((byte[])sha256_HMAC.doFinal(token.getAccessToken().getBytes(StandardCharsets.UTF_8)));
            String computedUrl = CommonHelper.addParameter((String)url, (String)APPSECRET_PARAMETER, (String)proof);
            return computedUrl;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new TechnicalException("Unable to compute appsecret_proof", (Throwable)e);
        }
    }

    @Override
    public FacebookProfile extractUserProfile(String body) {
        FacebookProfile profile = (FacebookProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(ProfileHelper.sanitizeIdentifier((UserProfile)profile, (Object)JsonHelper.getElement(json, "id")));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
            }
            this.extractData(profile, json, FRIENDS);
            this.extractData(profile, json, MOVIES);
            this.extractData(profile, json, MUSIC);
            this.extractData(profile, json, BOOKS);
            this.extractData(profile, json, LIKES);
            this.extractData(profile, json, ALBUMS);
            this.extractData(profile, json, EVENTS);
            this.extractData(profile, json, GROUPS);
            this.extractData(profile, json, MUSIC_LISTENS);
            this.extractData(profile, json, PICTURE);
        }
        return profile;
    }

    protected void extractData(FacebookProfile profile, JsonNode json, String name) {
        JsonNode data = (JsonNode)JsonHelper.getElement(json, name);
        if (data != null) {
            this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, name, JsonHelper.getElement(data, "data"));
        }
    }
}

