/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.scribe.builder.api;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.utils.OAuthEncoder;
import java.util.Map;
import org.pac4j.core.util.CommonHelper;

public class PayPalApi20
extends DefaultApi20 {
    private static final String AUTHORIZATION_URL = "https://www.paypal.com/webapps/auth/protocol/openidconnect/v1/authorize?client_id=%s&redirect_uri=%s&scope=%s&response_type=code&nonce=%s";

    public String getAuthorizationUrl(OAuthConfig config, Map<String, String> additionalParams) {
        CommonHelper.assertNotBlank((String)"config.getCallback()", (String)config.getCallback(), (String)"Must provide a valid url as callback. PayPal does not support OOB");
        String nonce = System.currentTimeMillis() + CommonHelper.randomString((int)10);
        return String.format(AUTHORIZATION_URL, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()), config.getScope() != null ? OAuthEncoder.encode((String)config.getScope()) : "", nonce);
    }

    protected String getAuthorizationBaseUrl() {
        return "https://www.paypal.com/webapps/auth/protocol/openidconnect/v1/authorize";
    }

    public String getAccessTokenEndpoint() {
        return "https://api.paypal.com/v1/identity/openidconnect/tokenservice";
    }
}

