/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.apis.LinkedInApi20;
import java.util.Optional;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.http.RedirectionActionHelper;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2Configuration;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2ProfileDefinition;

public class LinkedIn2Client
extends OAuth20Client {
    public LinkedIn2Client() {
        this.configuration = new LinkedIn2Configuration();
    }

    public LinkedIn2Client(String key, String secret) {
        this.configuration = new LinkedIn2Configuration();
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void clientInit() {
        CommonHelper.assertNotBlank((String)"scope", (String)this.getConfiguration().getScope());
        CommonHelper.assertNotBlank((String)"fields", (String)this.getConfiguration().getFields());
        this.configuration.setApi(LinkedInApi20.instance());
        this.configuration.setProfileDefinition(new LinkedIn2ProfileDefinition());
        this.configuration.setWithState(true);
        this.configuration.setHasBeenCancelledFactory(ctx -> {
            String error = ctx.getRequestParameter("error").orElse(null);
            String errorDescription = ctx.getRequestParameter("error_description").orElse(null);
            if ("access_denied".equals(error) && ("the+user+denied+your+request".equals(errorDescription) || "the user denied your request".equals(errorDescription))) {
                return true;
            }
            return false;
        });
        this.defaultLogoutActionBuilder((ctx, profile, targetUrl) -> Optional.of(RedirectionActionHelper.buildRedirectUrlAction((WebContext)ctx, (String)"https://www.linkedin.com/uas/logout")));
        super.clientInit();
    }

    @Override
    public LinkedIn2Configuration getConfiguration() {
        return (LinkedIn2Configuration)this.configuration;
    }

    public String getScope() {
        return this.getConfiguration().getScope();
    }

    public void setScope(String scope) {
        this.getConfiguration().setScope(scope);
    }

    public String getFields() {
        return this.getConfiguration().getFields();
    }

    public void setFields(String fields) {
        this.getConfiguration().setFields(fields);
    }
}

