/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.credentials.extractor;

import com.github.scribejava.core.utils.OAuthEncoder;
import java.util.Optional;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.credentials.OAuth20Credentials;
import org.pac4j.oauth.credentials.extractor.OAuthCredentialsExtractor;
import org.pac4j.oauth.exception.OAuthCredentialsException;

public class OAuth20CredentialsExtractor
extends OAuthCredentialsExtractor<OAuth20Credentials, OAuth20Configuration> {
    public OAuth20CredentialsExtractor(OAuth20Configuration configuration, IndirectClient client) {
        super(configuration, client);
    }

    @Override
    protected Optional<OAuth20Credentials> getOAuthCredentials(WebContext context) {
        Optional codeParameter;
        if (((OAuth20Configuration)this.configuration).isWithState()) {
            Optional stateParameter = context.getRequestParameter("state");
            if (stateParameter.isPresent()) {
                String stateSessionAttributeName = ((OAuth20Configuration)this.configuration).getStateSessionAttributeName(this.client.getName());
                String sessionState = context.getSessionStore().get(context, stateSessionAttributeName).orElse(null);
                context.getSessionStore().set(context, stateSessionAttributeName, null);
                this.logger.debug("sessionState: {} / stateParameter: {}", (Object)sessionState, (Object)stateParameter);
                if (!((String)stateParameter.get()).equals(sessionState)) {
                    String message = "State parameter mismatch: session expired or possible threat of cross-site request forgery";
                    throw new OAuthCredentialsException("State parameter mismatch: session expired or possible threat of cross-site request forgery");
                }
            } else {
                String message = "Missing state parameter: session expired or possible threat of cross-site request forgery";
                throw new OAuthCredentialsException("Missing state parameter: session expired or possible threat of cross-site request forgery");
            }
        }
        if ((codeParameter = context.getRequestParameter("code")).isPresent()) {
            String code = OAuthEncoder.decode((String)((String)codeParameter.get()));
            this.logger.debug("code: {}", (Object)code);
            return Optional.of(new OAuth20Credentials(code));
        }
        String message = "No credential found";
        throw new OAuthCredentialsException("No credential found");
    }
}

