/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.linkedin2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.OAuth2AccessToken;
import java.util.Arrays;
import java.util.List;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.BasicUserProfile;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.converter.JsonConverter;
import org.pac4j.oauth.profile.definition.OAuth20ProfileDefinition;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2Configuration;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2Location;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2Position;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2Profile;

public class LinkedIn2ProfileDefinition
extends OAuth20ProfileDefinition<LinkedIn2Profile, LinkedIn2Configuration> {
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String MAIDEN_NAME = "maidenName";
    public static final String FORMATTED_NAME = "formattedName";
    public static final String PHONETIC_FIRST_NAME = "phoneticFirstName";
    public static final String PHONETIC_LAST_NAME = "phoneticLastName";
    public static final String FORMATTED_PHONETIC_NAME = "formattedPhoneticName";
    public static final String HEADLINE = "headline";
    public static final String INDUSTRY = "industry";
    public static final String CURRENT_SHARE = "currentShare";
    public static final String NUM_CONNECTIONS = "numConnections";
    public static final String NUM_CONNECTIONS_CAPPED = "numConnectionsCapped";
    public static final String SUMMARY = "summary";
    public static final String SPECIALTIES = "specialties";
    public static final String POSITIONS = "positions";
    public static final String PICTURE_URL = "pictureUrl";
    public static final String PUBLIC_PROFILE_URL = "publicProfileUrl";
    public static final String SITE_STANDARD_PROFILE_REQUEST = "siteStandardProfileRequest";
    public static final String API_STANDARD_PROFILE_REQUEST = "apiStandardProfileRequest";
    public static final String EMAIL_ADDRESS = "emailAddress";

    public LinkedIn2ProfileDefinition() {
        super(x -> new LinkedIn2Profile());
        Arrays.stream(new String[]{FIRST_NAME, LAST_NAME, MAIDEN_NAME, FORMATTED_NAME, PHONETIC_FIRST_NAME, PHONETIC_LAST_NAME, FORMATTED_PHONETIC_NAME, HEADLINE, INDUSTRY, CURRENT_SHARE, SUMMARY, SPECIALTIES, EMAIL_ADDRESS}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.STRING));
        this.primary(NUM_CONNECTIONS, (AttributeConverter)Converters.INTEGER);
        this.primary(NUM_CONNECTIONS_CAPPED, (AttributeConverter)Converters.BOOLEAN);
        this.primary(PICTURE_URL, (AttributeConverter)Converters.URL);
        this.primary(PUBLIC_PROFILE_URL, (AttributeConverter)Converters.URL);
        this.primary("location", new JsonConverter<LinkedIn2Location>(LinkedIn2Location.class));
        this.secondary(POSITIONS, new JsonConverter<List<LinkedIn2Position>>(List.class, new TypeReference<List<LinkedIn2Position>>(){}));
    }

    @Override
    public String getProfileUrl(OAuth2AccessToken accessToken, LinkedIn2Configuration configuration) {
        return "https://api.linkedin.com/v1/people/~:(" + configuration.getFields() + ")?format=json";
    }

    @Override
    public LinkedIn2Profile extractUserProfile(String body) {
        LinkedIn2Profile profile = (LinkedIn2Profile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json == null) {
            this.raiseProfileExtractionJsonError(body);
        }
        profile.setId(ProfileHelper.sanitizeIdentifier((BasicUserProfile)profile, (Object)JsonHelper.getElement(json, "id")));
        for (String attribute : this.getPrimaryAttributes()) {
            this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
        }
        Object positions = JsonHelper.getElement(json, POSITIONS);
        if (positions != null && positions instanceof JsonNode) {
            this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, POSITIONS, JsonHelper.getElement((JsonNode)positions, "values"));
        }
        this.addUrl(profile, json, SITE_STANDARD_PROFILE_REQUEST);
        this.addUrl(profile, json, API_STANDARD_PROFILE_REQUEST);
        return profile;
    }

    private void addUrl(LinkedIn2Profile profile, JsonNode json, String name) {
        String url = (String)JsonHelper.getElement(json, name + ".url");
        this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, name, url);
    }
}

