/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.core.model.Verb;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Stream;
import org.pac4j.core.profile.converter.AbstractAttributeConverter;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.generic.GenericOAuth20ProfileDefinition;
import org.pac4j.scribe.builder.api.GenericApi20;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericOAuth20Client
extends OAuth20Client {
    private static final Logger LOG = LoggerFactory.getLogger(GenericOAuth20Client.class);
    private String authUrl;
    private String tokenUrl;
    private String profileUrl;
    private String profilePath;
    private String profileId;
    private String scope;
    private boolean withState;
    private String clientAuthenticationMethod;
    private Verb profileVerb;
    private Map<String, String> profileAttrs;
    private Map<String, String> customParams;
    private Class[] converterClasses;

    @Override
    protected void internalInit() {
        GenericApi20 genApi = new GenericApi20(this.authUrl, this.tokenUrl);
        this.configuration.setApi((Object)genApi);
        if (this.clientAuthenticationMethod != null) {
            genApi.setClientAuthenticationMethod(this.clientAuthenticationMethod);
        }
        this.configuration.setCustomParams(this.customParams);
        GenericOAuth20ProfileDefinition profileDefinition = new GenericOAuth20ProfileDefinition();
        profileDefinition.setFirstNodePath(this.profilePath);
        profileDefinition.setProfileVerb(this.profileVerb);
        profileDefinition.setProfileUrl(this.profileUrl);
        if (this.profileId != null) {
            profileDefinition.setProfileId(this.profileId);
        } else {
            profileDefinition.setProfileId("id");
        }
        if (this.profileAttrs != null) {
            for (Map.Entry<String, String> entry : this.profileAttrs.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                String[] tokens = value.split("\\|");
                if (tokens.length == 2) {
                    profileDefinition.profileAttribute(key, tokens[1], (AttributeConverter)this.getConverter(tokens[0]));
                    continue;
                }
                if (tokens.length == 1) {
                    profileDefinition.profileAttribute(key, value, null);
                    continue;
                }
                LOG.warn("Ignored incorrect attribute value expressions: {}", (Object)value);
            }
        }
        this.configuration.setProfileDefinition(profileDefinition);
        this.configuration.setScope(this.scope);
        this.configuration.setWithState(this.withState);
        super.internalInit();
    }

    private Class[] getConverters() {
        if (this.converterClasses == null) {
            try {
                Class<?> cla;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                for (cla = classLoader.getClass(); cla != ClassLoader.class; cla = cla.getSuperclass()) {
                }
                Field field = cla.getDeclaredField("classes");
                field.setAccessible(true);
                Vector classes = (Vector)field.get(classLoader);
                this.converterClasses = (Class[])classes.stream().filter(x -> AbstractAttributeConverter.class.isAssignableFrom((Class<?>)x) && !Modifier.isAbstract(x.getModifiers())).toArray(Class[]::new);
                return this.converterClasses;
            }
            catch (Exception e) {
                LOG.warn(e.toString());
            }
        }
        return this.converterClasses;
    }

    private AbstractAttributeConverter getConverter(String typeName) {
        try {
            Stream<Class> acceptableConverters = Arrays.stream(this.getConverters()).filter(x -> {
                try {
                    AbstractAttributeConverter converter = (AbstractAttributeConverter)x.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Method accept = AbstractAttributeConverter.class.getDeclaredMethod("accept", String.class);
                    return (Boolean)accept.invoke((Object)converter, typeName);
                }
                catch (ReflectiveOperationException e) {
                    LOG.warn("Ignore type which no parameterless constructor:" + x.getName());
                    return false;
                }
            });
            Class converterClazz = acceptableConverters.findFirst().get();
            return (AbstractAttributeConverter)converterClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.warn(e.toString());
            return null;
        }
    }

    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
    }

    public void setProfileNodePath(String profilePath) {
        this.profilePath = profilePath;
    }

    public void setProfileVerb(Verb profileVerb) {
        this.profileVerb = profileVerb;
    }

    public void setProfileAttrs(Map<String, String> profileAttrsMap) {
        this.profileAttrs = profileAttrsMap;
    }

    public void setCustomParams(Map<String, String> customParamsMap) {
        this.customParams = customParamsMap;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isWithState() {
        return this.withState;
    }

    public void setWithState(boolean withState) {
        this.withState = withState;
    }

    public String getClientAuthenticationMethod() {
        return this.clientAuthenticationMethod;
    }

    public void setClientAuthenticationMethod(String clientAuthenticationMethod) {
        this.clientAuthenticationMethod = clientAuthenticationMethod;
    }
}

